/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class msgsend {
    public static void main(String[] argv) {
        int optind;
        String subject = null;
        String from = null;
        String cc = null;
        String bcc = null;
        String url = null;
        String mailhost = null;
        String mailer = "msgsend";
        String file = null;
        String protocol = null;
        String host = null;
        String user = null;
        String password = null;
        String record = null;
        boolean debug = false;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        for (optind = 0; optind < argv.length; ++optind) {
            if (argv[optind].equals("-T")) {
                protocol = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-H")) {
                host = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-U")) {
                user = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-P")) {
                password = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-M")) {
                mailhost = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-f")) {
                record = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-a")) {
                file = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-s")) {
                subject = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-o")) {
                from = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-c")) {
                cc = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-b")) {
                bcc = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-L")) {
                url = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-d")) {
                debug = true;
                continue;
            }
            if (argv[optind].equals("--")) {
                ++optind;
                break;
            }
            if (!argv[optind].startsWith("-")) break;
            System.out.println("Usage: msgsend [[-L store-url] | [-T prot] [-H host] [-U user] [-P passwd]]");
            System.out.println("\t[-s subject] [-o from-address] [-c cc-addresses] [-b bcc-addresses]");
            System.out.println("\t[-f record-mailbox] [-M transport-host] [-a attach-file] [-d] [address]");
            System.exit(1);
        }
        try {
            String to;
            if (optind < argv.length) {
                to = argv[optind];
                System.out.println("To: " + to);
            } else {
                System.out.print("To: ");
                System.out.flush();
                to = in.readLine();
            }
            if (subject == null) {
                System.out.print("Subject: ");
                System.out.flush();
                subject = in.readLine();
            } else {
                System.out.println("Subject: " + subject);
            }
            Properties props = System.getProperties();
            if (mailhost != null) {
                props.put("mail.smtp.host", mailhost);
            }
            Session session = Session.getInstance((Properties)props, null);
            if (debug) {
                session.setDebug(true);
            }
            MimeMessage msg = new MimeMessage(session);
            if (from != null) {
                msg.setFrom((Address)new InternetAddress(from));
            } else {
                msg.setFrom();
            }
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)to, (boolean)false));
            if (cc != null) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse(cc, (boolean)false));
            }
            if (bcc != null) {
                msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse(bcc, (boolean)false));
            }
            msg.setSubject(subject);
            String text = msgsend.collect(in);
            if (file != null) {
                MimeBodyPart mbp1 = new MimeBodyPart();
                mbp1.setText(text);
                MimeBodyPart mbp2 = new MimeBodyPart();
                mbp2.attachFile(file);
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)mbp1);
                mp.addBodyPart((BodyPart)mbp2);
                msg.setContent((Multipart)mp);
            } else {
                msg.setText(text);
            }
            msg.setHeader("X-Mailer", mailer);
            msg.setSentDate(new Date());
            Transport.send((Message)msg);
            System.out.println("\nMail was sent successfully.");
            if (record != null) {
                Store store = null;
                if (url != null) {
                    URLName urln = new URLName(url);
                    store = session.getStore(urln);
                    store.connect();
                } else {
                    store = protocol != null ? session.getStore(protocol) : session.getStore();
                    if (host != null || user != null || password != null) {
                        store.connect(host, user, password);
                    } else {
                        store.connect();
                    }
                }
                Folder folder = store.getFolder(record);
                if (folder == null) {
                    System.err.println("Can't get record folder.");
                    System.exit(1);
                }
                if (!folder.exists()) {
                    folder.create(1);
                }
                Message[] msgs = new Message[]{msg};
                folder.appendMessages(msgs);
                System.out.println("Mail was recorded successfully.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String collect(BufferedReader in) throws IOException {
        String line;
        StringBuffer sb = new StringBuffer();
        while ((line = in.readLine()) != null) {
            sb.append(line);
            sb.append("\n");
        }
        return sb.toString();
    }
}

