/*
 * Decompiled with CFR 0.152.
 */
import java.util.Properties;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;
import javax.mail.internet.MimeMessage;

public class populate {
    static boolean force = false;
    static boolean skipSpecial = false;
    static boolean clear = false;
    static boolean dontPreserveFlags = false;
    static boolean warn = false;

    public static void main(String[] argv) {
        String srcURL = null;
        String dstURL = null;
        boolean debug = false;
        for (int optind = 0; optind < argv.length; ++optind) {
            if (argv[optind].equals("-s")) {
                srcURL = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-d")) {
                dstURL = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-D")) {
                debug = true;
                continue;
            }
            if (argv[optind].equals("-f")) {
                force = true;
                continue;
            }
            if (argv[optind].equals("-S")) {
                skipSpecial = true;
                continue;
            }
            if (argv[optind].equals("-c")) {
                clear = true;
                continue;
            }
            if (argv[optind].equals("-P")) {
                dontPreserveFlags = true;
                continue;
            }
            if (argv[optind].equals("-W")) {
                warn = true;
                continue;
            }
            if (argv[optind].equals("--")) {
                ++optind;
                break;
            }
            if (!argv[optind].startsWith("-")) break;
            populate.printUsage();
            System.exit(1);
        }
        try {
            Folder dstFolder;
            Folder srcFolder;
            if (srcURL == null || dstURL == null) {
                populate.printUsage();
                System.exit(1);
            }
            Session session = Session.getInstance((Properties)System.getProperties(), null);
            session.setDebug(debug);
            URLName srcURLName = new URLName(srcURL);
            if (srcURLName.getFile() == null) {
                Store s = session.getStore(srcURLName);
                s.connect();
                srcFolder = s.getDefaultFolder();
            } else {
                srcFolder = session.getFolder(new URLName(srcURL));
                if (!srcFolder.exists()) {
                    System.out.println("source folder does not exist");
                    srcFolder.getStore().close();
                    System.exit(1);
                }
            }
            URLName dstURLName = new URLName(dstURL);
            if (dstURLName.getFile() == null) {
                Store s = session.getStore(dstURLName);
                s.connect();
                dstFolder = s.getFolder(srcFolder.getName());
            } else {
                dstFolder = session.getFolder(dstURLName);
            }
            if (clear && dstFolder.exists() && !dstFolder.delete(true)) {
                System.out.println("couldn't delete " + dstFolder.getFullName());
                return;
            }
            populate.copy(srcFolder, dstFolder);
            srcFolder.getStore().close();
            dstFolder.getStore().close();
        }
        catch (MessagingException mex) {
            System.out.println(mex.getMessage());
            mex.printStackTrace();
        }
    }

    private static void copy(Folder src, Folder dst) throws MessagingException {
        boolean srcHasChildren;
        System.out.println("Populating " + dst.getFullName());
        Folder ddst = dst;
        Folder[] srcFolders = null;
        if ((src.getType() & 2) != 0) {
            srcFolders = src.list();
        }
        boolean bl = srcHasChildren = srcFolders != null && srcFolders.length > 0;
        if (!dst.exists()) {
            boolean dstHoldsOnlyFolders = false;
            if (!dst.create(src.getType())) {
                if (!dst.create(srcHasChildren ? 2 : 1) && !dst.create(1)) {
                    System.out.println("couldn't create " + dst.getFullName());
                    return;
                }
                dstHoldsOnlyFolders = srcHasChildren;
            }
            if ((src.getType() & 1) != 0) {
                src.open(1);
                if (dstHoldsOnlyFolders) {
                    if (src.getMessageCount() > 0) {
                        System.out.println("Unable to copy messages from " + src.getFullName() + " to " + dst.getFullName() + " because destination holds only folders");
                    }
                } else {
                    populate.copyMessages(src, dst);
                }
                src.close(false);
            }
        } else {
            System.out.println(dst.getFullName() + " already exists");
            if (force && (src.getType() & 1) != 0) {
                src.open(1);
                populate.copyMessages(src, dst);
                src.close(false);
            }
        }
        if (srcHasChildren) {
            for (int i = 0; i < srcFolders.length; ++i) {
                if (skipSpecial && (srcFolders[i].getName().equals("SCCS") || srcFolders[i].getName().equals("Drafts") || srcFolders[i].getName().equals("Trash") || srcFolders[i].getName().equals("Shared Folders"))) continue;
                populate.copy(srcFolders[i], dst.getFolder(srcFolders[i].getName()));
            }
        }
    }

    private static void copyMessages(Folder src, Folder dst) throws MessagingException {
        int i;
        Message[] msgs = src.getMessages();
        if (dontPreserveFlags) {
            for (i = 0; i < msgs.length; ++i) {
                MimeMessage m = new MimeMessage((MimeMessage)msgs[i]);
                m.setFlags(m.getFlags(), false);
                msgs[i] = m;
            }
        }
        if (warn) {
            for (i = 0; i < msgs.length; ++i) {
                try {
                    src.copyMessages(new Message[]{msgs[i]}, dst);
                    continue;
                }
                catch (MessagingException mex) {
                    System.out.println("WARNING: Copy of message " + (i + 1) + " from " + src.getFullName() + " to " + dst.getFullName() + " failed: " + mex.toString());
                }
            }
        } else {
            src.copyMessages(msgs, dst);
        }
    }

    private static void printUsage() {
        System.out.println("populate [-D] [-f] [-S] [-c] -s source_url -d dest_url");
        System.out.println("URLs are of the form: protocol://username:password@hostname/foldername");
        System.out.println("The destination URL does not need a foldername, in which case, the source foldername is used");
    }
}

