/*
 * Decompiled with CFR 0.152.
 */
import java.util.Properties;
import javax.mail.Address;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.Provider;
import javax.mail.Session;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.NewsAddress;

public class registry {
    static Provider _aProvider;
    static Provider _bProvider;
    static Provider _sunSMTP;
    static Provider _sunIMAP;

    public static void main(String[] args) {
        Properties props = new Properties();
        props.put("mail.transport.protocol", "smtp");
        props.put("mail.store.protocol", "imap");
        props.put("mail.smtp.class", "com.sun.mail.smtp.SMTPTransport");
        props.put("mail.imap.class", "com.sun.mail.imap.IMAPStore");
        Session session = Session.getInstance((Properties)props, null);
        System.out.println("\n------ getProviders()----------");
        Provider[] providers = session.getProviders();
        for (int i = 0; i < providers.length; ++i) {
            System.out.println("** " + providers[i]);
            String s = null;
            s = providers[i].getVendor();
            if (s != null && s.startsWith("ACME Corp")) {
                _aProvider = providers[i];
            }
            if (providers[i].getClassName().endsWith("application.smtp")) {
                _bProvider = providers[i];
            }
            if (providers[i].getClassName().equals("com.sun.mail.imap.IMAPStore")) {
                _sunIMAP = providers[i];
            }
            if ((s = providers[i].getVendor()) == null || !s.startsWith("Oracle") || providers[i].getType() != Provider.Type.TRANSPORT || !providers[i].getProtocol().equalsIgnoreCase("smtp")) continue;
            _sunSMTP = providers[i];
        }
        System.out.println("\n------ initial protocol defaults -------");
        try {
            System.out.println("imap: " + session.getProvider("imap"));
            System.out.println("smtp: " + session.getProvider("smtp"));
            System.out.println("nntp: " + session.getProvider("nntp"));
        }
        catch (NoSuchProviderException mex) {
            System.out.println(">> This exception is OK since there is no NNTP Provider configured by default");
            mex.printStackTrace();
        }
        System.out.println("\n------ set new protocol defaults ------");
        try {
            session.setProvider(_aProvider);
        }
        catch (NoSuchProviderException mex) {
            System.out.println(">> Exception expected: _aProvider is null");
            mex.printStackTrace();
        }
        try {
            session.setProvider(_sunIMAP);
        }
        catch (NoSuchProviderException mex) {
            mex.printStackTrace();
        }
        try {
            System.out.println("imap: " + session.getProvider("imap"));
            System.out.println("smtp: " + session.getProvider("smtp"));
        }
        catch (NoSuchProviderException mex) {
            mex.printStackTrace();
        }
        System.out.println("\n\n----- get some stores ---------");
        try {
            System.out.println("getStore(): " + session.getStore());
            System.out.println("getStore(Provider): " + session.getStore(_sunIMAP));
        }
        catch (NoSuchProviderException mex) {
            mex.printStackTrace();
        }
        try {
            System.out.println("getStore(imap): " + session.getStore("imap"));
            System.out.println("getStore(pop3): " + session.getStore("pop3"));
        }
        catch (NoSuchProviderException mex) {
            System.out.println(">> Exception expected: no pop3 provider");
            mex.printStackTrace();
        }
        System.out.println("\n\n----- now for transports/addresses ---------");
        try {
            System.out.println("getTransport(): " + session.getTransport());
            System.out.println("getTransport(Provider): " + session.getTransport(_sunSMTP));
            System.out.println("getTransport(smtp): " + session.getTransport("smtp"));
            System.out.println("getTransport(Address): " + session.getTransport((Address)new InternetAddress("mspivak@apilon")));
            System.out.println("getTransport(News): " + session.getTransport((Address)new NewsAddress("rec.humor")));
        }
        catch (MessagingException mex) {
            System.out.println(">> Exception expected: no news provider configured");
            mex.printStackTrace();
        }
    }
}

