/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.FetchProfile;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.UIDFolder;
import javax.mail.URLName;

public class uidmsgshow {
    static String protocol;
    static String host;
    static String user;
    static String password;
    static String mbox;
    static String url;
    static boolean verbose;

    public static void main(String[] argv) {
        int optind;
        long uid = -1L;
        for (optind = 0; optind < argv.length; ++optind) {
            if (argv[optind].equals("-T")) {
                protocol = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-H")) {
                host = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-U")) {
                user = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-P")) {
                password = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-v")) {
                verbose = true;
                continue;
            }
            if (argv[optind].equals("-f")) {
                mbox = argv[++optind];
                continue;
            }
            if (argv[optind].equals("-L")) {
                url = argv[++optind];
                continue;
            }
            if (argv[optind].equals("--")) {
                ++optind;
                break;
            }
            if (!argv[optind].startsWith("-")) break;
            System.out.println("Usage: uidmsgshow [-L url] [-T protocol] [-H host] [-U user] [-P password] [-f mailbox] [uid] [-v]");
            System.exit(1);
        }
        try {
            if (optind < argv.length) {
                uid = Long.parseLong(argv[optind]);
            }
            Properties props = System.getProperties();
            Session session = Session.getInstance((Properties)props, null);
            Store store = null;
            if (url != null) {
                URLName urln = new URLName(url);
                store = session.getStore(urln);
                store.connect();
            } else {
                store = protocol != null ? session.getStore(protocol) : session.getStore();
                if (host != null || user != null || password != null) {
                    store.connect(host, user, password);
                } else {
                    store.connect();
                }
            }
            Folder folder = store.getDefaultFolder();
            if (folder == null) {
                System.out.println("No default folder");
                System.exit(1);
            }
            if (!(folder = folder.getFolder(mbox)).exists()) {
                System.out.println(mbox + "  does not exist");
                System.exit(1);
            }
            if (!(folder instanceof UIDFolder)) {
                System.out.println("This Provider or this folder does not support UIDs");
                System.exit(1);
            }
            UIDFolder ufolder = (UIDFolder)folder;
            folder.open(2);
            int totalMessages = folder.getMessageCount();
            if (totalMessages == 0) {
                System.out.println("Empty folder");
                folder.close(false);
                store.close();
                System.exit(1);
            }
            if (verbose) {
                int newMessages = folder.getNewMessageCount();
                System.out.println("Total messages = " + totalMessages);
                System.out.println("New messages = " + newMessages);
                System.out.println("-------------------------------");
            }
            if (uid == -1L) {
                Message[] msgs = ufolder.getMessagesByUID(1L, -1L);
                FetchProfile fp = new FetchProfile();
                fp.add(FetchProfile.Item.ENVELOPE);
                fp.add(FetchProfile.Item.FLAGS);
                fp.add("X-Mailer");
                folder.fetch(msgs, fp);
                for (int i = 0; i < msgs.length; ++i) {
                    System.out.println("--------------------------");
                    System.out.println("MESSAGE UID #" + ufolder.getUID(msgs[i]) + ":");
                    uidmsgshow.dumpEnvelope(msgs[i]);
                }
            } else {
                System.out.println("Getting message UID: " + uid);
                Message m = ufolder.getMessageByUID(uid);
                if (m != null) {
                    uidmsgshow.dumpPart((Part)m);
                } else {
                    System.out.println("This Message does not exist on this folder");
                }
            }
            folder.close(false);
            store.close();
        }
        catch (Exception ex) {
            System.out.println("Oops, got exception! " + ex.getMessage());
            ex.printStackTrace();
        }
        System.exit(1);
    }

    public static void dumpPart(Part p) throws Exception {
        block4: {
            int c;
            Object o;
            block6: {
                block5: {
                    block3: {
                        if (p instanceof Message) {
                            uidmsgshow.dumpEnvelope((Message)p);
                        }
                        System.out.println("CONTENT-TYPE: " + p.getContentType());
                        o = p.getContent();
                        if (!(o instanceof String)) break block3;
                        System.out.println("This is a String");
                        System.out.println("---------------------------");
                        System.out.println((String)o);
                        break block4;
                    }
                    if (!(o instanceof Multipart)) break block5;
                    System.out.println("This is a Multipart");
                    System.out.println("---------------------------");
                    Multipart mp = (Multipart)o;
                    int count = mp.getCount();
                    for (int i = 0; i < count; ++i) {
                        uidmsgshow.dumpPart((Part)mp.getBodyPart(i));
                    }
                    break block4;
                }
                if (!(o instanceof Message)) break block6;
                System.out.println("This is a Nested Message");
                System.out.println("---------------------------");
                uidmsgshow.dumpPart((Part)o);
                break block4;
            }
            if (!(o instanceof InputStream)) break block4;
            System.out.println("This is just an input stream");
            System.out.println("---------------------------");
            InputStream is = (InputStream)o;
            while ((c = is.read()) != -1) {
                System.out.write(c);
            }
        }
    }

    public static void dumpEnvelope(Message m) throws Exception {
        int j;
        System.out.println("This is the message envelope");
        System.out.println("---------------------------");
        Address[] a = m.getFrom();
        if (a != null) {
            for (j = 0; j < a.length; ++j) {
                System.out.println("FROM: " + a[j].toString());
            }
        }
        if ((a = m.getRecipients(Message.RecipientType.TO)) != null) {
            for (j = 0; j < a.length; ++j) {
                System.out.println("TO: " + a[j].toString());
            }
        }
        System.out.println("SUBJECT: " + m.getSubject());
        Date d = m.getSentDate();
        System.out.println("SendDate: " + (d != null ? d.toString() : "UNKNOWN"));
        System.out.println("Size: " + m.getSize());
        Flags flags = m.getFlags();
        StringBuffer sb = new StringBuffer();
        Flags.Flag[] sf = flags.getSystemFlags();
        boolean first = true;
        for (int i = 0; i < sf.length; ++i) {
            String s;
            Flags.Flag f = sf[i];
            if (f == Flags.Flag.ANSWERED) {
                s = "\\Answered";
            } else if (f == Flags.Flag.DELETED) {
                s = "\\Deleted";
            } else if (f == Flags.Flag.DRAFT) {
                s = "\\Draft";
            } else if (f == Flags.Flag.FLAGGED) {
                s = "\\Flagged";
            } else if (f == Flags.Flag.RECENT) {
                s = "\\Recent";
            } else {
                if (f != Flags.Flag.SEEN) continue;
                s = "\\Seen";
            }
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(s);
        }
        String[] uf = flags.getUserFlags();
        for (int i = 0; i < uf.length; ++i) {
            if (first) {
                first = false;
            } else {
                sb.append(' ');
            }
            sb.append(uf[i]);
        }
        System.out.println("FLAGS = " + sb.toString());
        String[] hdrs = m.getHeader("X-Mailer");
        if (hdrs != null) {
            System.out.println("X-Mailer: " + hdrs[0]);
        } else {
            System.out.println("X-Mailer NOT available");
        }
    }

    static {
        host = null;
        user = null;
        password = null;
        mbox = "INBOX";
        url = null;
        verbose = false;
    }
}

