/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import com.sun.mail.mbox.DefaultMailbox;
import com.sun.mail.mbox.MailFile;
import com.sun.mail.mbox.Mailbox;
import com.sun.mail.mbox.MboxFolder;
import javax.mail.AuthenticationFailedException;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.URLName;

public class MboxStore
extends Store {
    String user = System.getProperty("user.name");
    String home = System.getProperty("user.home");
    Mailbox mb;
    static Flags permFlags = new Flags();

    public MboxStore(Session session, URLName url) {
        super(session, url);
        String os = System.getProperty("os.name");
        try {
            String cl = "com.sun.mail.mbox." + os + "Mailbox";
            this.mb = (Mailbox)Class.forName(cl).newInstance();
        }
        catch (Exception e) {
            this.mb = new DefaultMailbox();
        }
    }

    protected boolean protocolConnect(String host, int port, String user, String passwd) throws MessagingException {
        if (passwd != null) {
            throw new AuthenticationFailedException("mbox does not allow passwords");
        }
        return true;
    }

    protected void setURLName(URLName url) {
        if (url != null && (url.getUsername() != null || url.getHost() != null || url.getFile() != null)) {
            url = new URLName(url.getProtocol(), null, -1, null, null, null);
        }
        super.setURLName(url);
    }

    public Folder getDefaultFolder() throws MessagingException {
        this.checkConnected();
        return new MboxFolder(this, null);
    }

    public Folder getFolder(String name) throws MessagingException {
        this.checkConnected();
        return new MboxFolder(this, name);
    }

    public Folder getFolder(URLName url) throws MessagingException {
        this.checkConnected();
        return this.getFolder(url.getFile());
    }

    private void checkConnected() throws MessagingException {
        if (!this.isConnected()) {
            throw new MessagingException("Not connected");
        }
    }

    MailFile getMailFile(String folder) {
        return this.mb.getMailFile(this.user, folder);
    }

    Session getSession() {
        return this.session;
    }

    static {
        permFlags.add(Flags.Flag.SEEN);
        permFlags.add(Flags.Flag.RECENT);
        permFlags.add(Flags.Flag.DELETED);
        permFlags.add(Flags.Flag.FLAGGED);
        permFlags.add(Flags.Flag.ANSWERED);
        permFlags.add(Flags.Flag.DRAFT);
        permFlags.add(Flags.Flag.USER);
    }
}

