/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mail.mbox;

import com.sun.mail.mbox.AppendStream;
import com.sun.mail.mbox.MboxFolder;
import com.sun.mail.mbox.TempFile;
import java.io.EOFException;
import java.io.FileDescriptor;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.List;

final class MessageLoader {
    private final TempFile temp;
    private FileInputStream fis = null;
    private AppendStream fos = null;
    private int pos;
    private int len;
    private long off;
    private long prevend;
    private MboxFolder.MessageMetadata md;
    private byte[] buf = null;
    private static final int LINELEN = "Content-Length: XXXXXXXXXX".length();
    private char[] line;

    public MessageLoader(TempFile temp) {
        this.temp = temp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int load(FileDescriptor fd, long offset, List msgs) throws IOException {
        int loaded = 0;
        try {
            int n;
            this.fis = new FileInputStream(fd);
            if (this.fis.skip(offset) != offset) {
                throw new EOFException("Failed to skip to offset " + offset);
            }
            this.off = this.prevend = this.temp.length();
            this.len = 0;
            this.pos = 0;
            this.line = new char[LINELEN];
            this.buf = new byte[65536];
            this.fos = this.temp.getAppendStream();
            while ((n = this.skipHeader(loaded == 0)) >= 0) {
                long start;
                if (n == 0) {
                    start = this.skipBody();
                    if (start < 0L) {
                        this.md.dataend = -1L;
                        this.md.end = -1L;
                        msgs.add(this.md);
                        ++loaded;
                        break;
                    }
                    this.md.dataend = start;
                } else {
                    int b;
                    this.skip(n);
                    this.md.dataend = this.off;
                    while ((b = this.get()) >= 0 && b == 10) {
                    }
                    start = this.off;
                    if (b >= 0) {
                        // empty if block
                    }
                }
                this.md.end = this.prevend = --start;
                msgs.add(this.md);
                ++loaded;
            }
        }
        finally {
            try {
                this.fis.close();
            }
            catch (IOException iOException) {}
            try {
                this.fos.close();
            }
            catch (IOException iOException) {}
            this.line = null;
            this.buf = null;
        }
        return loaded;
    }

    private int skipHeader(boolean first) throws IOException {
        int b;
        int clen = 0;
        boolean bol = true;
        int lpos = -1;
        boolean saw_unix_from = false;
        int lineno = 0;
        this.md = new MboxFolder.MessageMetadata();
        this.md.start = this.prevend;
        this.md.recent = true;
        while ((b = this.get()) >= 0) {
            if (bol) {
                if (b == 10) break;
                lpos = 0;
            }
            if (b == 10) {
                bol = true;
                ++lineno;
                if (lpos <= 7) continue;
                String s = new String(this.line, 0, lpos);
                if (lineno == 1 && this.line[0] == 'F' && MessageLoader.isPrefix(s, "From ")) {
                    saw_unix_from = true;
                    continue;
                }
                if (this.line[7] == '-' && MessageLoader.isPrefix(s, "Content-Length:")) {
                    s = s.substring(15).trim();
                    try {
                        clen = Integer.parseInt(s);
                    }
                    catch (NumberFormatException numberFormatException) {}
                    continue;
                }
                if ((this.line[1] == 't' || this.line[1] == 'T') && MessageLoader.isPrefix(s, "Status:")) {
                    if (s.indexOf(79) < 0) continue;
                    this.md.recent = false;
                    continue;
                }
                if ((this.line[3] == 't' || this.line[3] == 'T') && MessageLoader.isPrefix(s, "X-Status:")) {
                    if (s.indexOf(68) < 0) continue;
                    this.md.deleted = true;
                    continue;
                }
                if (this.line[4] == '-' && MessageLoader.isPrefix(s, "X-Dt-Delete-Time:")) {
                    this.md.deleted = true;
                    continue;
                }
                if (this.line[5] != 'P' || !s.startsWith("X-IMAP:")) continue;
                this.md.imap = true;
                continue;
            }
            bol = false;
            if (lpos < 0) continue;
            if (lpos == 0 && (b == 32 || b == 9)) {
                lpos = -1;
                continue;
            }
            if (lpos >= this.line.length) continue;
            this.line[lpos++] = (char)b;
        }
        if (b < 0 || first && !saw_unix_from) {
            return -1;
        }
        return clen;
    }

    private static final boolean isPrefix(String s, String pre) {
        return s.regionMatches(true, 0, pre, 0, pre.length());
    }

    private long skipBody() throws IOException {
        int b;
        boolean bol = true;
        int lpos = -1;
        long loff = this.off;
        while ((b = this.get()) >= 0) {
            if (bol) {
                lpos = 0;
                loff = this.off - 1L;
            }
            if (b == 10) {
                bol = true;
                if (lpos < 5 || this.line[0] != 'F' || this.line[1] != 'r' || this.line[2] != 'o' || this.line[3] != 'm' || this.line[4] != ' ') continue;
                return loff;
            }
            bol = false;
            if (lpos < 0) continue;
            if (lpos == 0 && b != 70) {
                lpos = -1;
                continue;
            }
            if (lpos >= 5) continue;
            this.line[lpos++] = (char)b;
        }
        return -1L;
    }

    private final int skip(int n) throws IOException {
        int n0 = n;
        if (this.pos + n < this.len) {
            this.pos += n;
            this.off += (long)n;
        } else {
            do {
                n -= this.len - this.pos;
                this.off += (long)(this.len - this.pos);
                this.fill();
                if (this.len > 0) continue;
                return n0 - n;
            } while (n > this.len);
            this.pos += n;
            this.off += (long)n;
        }
        return n0;
    }

    private final int get() throws IOException {
        if (this.pos >= this.len) {
            this.fill();
        }
        if (this.pos >= this.len) {
            return -1;
        }
        ++this.off;
        return this.buf[this.pos++] & 0xFF;
    }

    private final void fill() throws IOException {
        this.len = this.fis.read(this.buf);
        this.pos = 0;
        if (this.len > 0) {
            this.fos.write(this.buf, 0, this.len);
        }
    }
}

