/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.apache.pdfbox.pdmodel.font;

import java.util.List;

/**
 * External font service provider interface.
 *
 * @author John Hewson
 */
public abstract class FontProvider
{
    /**
     * Returns a string containing debugging information. This will be written to the log if no suitable fonts are found
     * and no fallback fonts are available. May be null.
     * 
     * @return string with debug information or null
     */
    public abstract String toDebugString();

    /**
     * Returns a list of information about fonts on the system.
     * 
     * @return a list of FntInfo instances for all fonts on the system
     */
    public abstract List<? extends FontInfo> getFontInfo();
}
