/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.cos;

import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.ICOSVisitor;

public class COSFloat
extends COSNumber {
    private Float value;
    private String valueAsString;

    public COSFloat(float aFloat) {
        this.value = Float.valueOf(aFloat);
    }

    public COSFloat(String aFloat) throws IOException {
        try {
            this.value = Float.valueOf(Float.parseFloat(aFloat));
            this.valueAsString = this.checkMinMaxValues() ? null : aFloat;
        }
        catch (NumberFormatException e) {
            if (aFloat.startsWith("--")) {
                aFloat = aFloat.substring(1);
            } else if (aFloat.matches("^0\\.0*-\\d+")) {
                aFloat = "-" + aFloat.replaceFirst("-", "");
            } else {
                throw new IOException("Error expected floating point number actual='" + aFloat + "'", e);
            }
            try {
                this.value = Float.valueOf(Float.parseFloat(aFloat));
                this.checkMinMaxValues();
            }
            catch (NumberFormatException e2) {
                throw new IOException("Error expected floating point number actual='" + aFloat + "'", e2);
            }
        }
    }

    private boolean checkMinMaxValues() {
        if (this.value.floatValue() == Float.POSITIVE_INFINITY) {
            this.value = Float.valueOf(Float.MAX_VALUE);
        } else if (this.value.floatValue() == Float.NEGATIVE_INFINITY) {
            this.value = Float.valueOf(-3.4028235E38f);
        } else if (Math.abs(this.value.floatValue()) < Float.MIN_NORMAL) {
            this.value = Float.valueOf(0.0f);
        } else {
            return false;
        }
        return true;
    }

    private String trimZeros(String plainStringValue) {
        int lastIndex = plainStringValue.lastIndexOf(46);
        if (lastIndex > 0) {
            int i;
            for (i = plainStringValue.length() - 1; i > lastIndex + 1 && plainStringValue.charAt(i) == '0'; --i) {
            }
            return plainStringValue.substring(0, i + 1);
        }
        return plainStringValue;
    }

    @Override
    public float floatValue() {
        return this.value.floatValue();
    }

    @Override
    public long longValue() {
        return this.value.longValue();
    }

    @Override
    public int intValue() {
        return this.value.intValue();
    }

    public boolean equals(Object o) {
        return o instanceof COSFloat && Float.floatToIntBits(((COSFloat)o).value.floatValue()) == Float.floatToIntBits(this.value.floatValue());
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public String toString() {
        return "COSFloat{" + this.formatString() + "}";
    }

    private String formatString() {
        if (this.valueAsString == null) {
            this.valueAsString = this.trimZeros(new BigDecimal(String.valueOf(this.value)).toPlainString());
        }
        return this.valueAsString;
    }

    @Override
    public void accept(ICOSVisitor visitor) throws IOException {
        visitor.visitFromFloat(this);
    }

    public void writePDF(OutputStream output) throws IOException {
        output.write(this.formatString().getBytes(StandardCharsets.ISO_8859_1));
    }
}

