/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.weaver;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bundlebee.registry.Registry;
import org.bundlebee.remoteservicecall.BundleLifecycleClient;
import org.bundlebee.weaver.ServiceCallDispatchStrategy;
import org.bundlebee.weaver.ServiceCallStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleStateDispatchStrategy
implements ServiceCallDispatchStrategy {
    private static Logger LOG = LoggerFactory.getLogger(BundleStateDispatchStrategy.class);
    private Registry registry;
    private BundleLifecycleClient bundleLifecycleClient = new BundleLifecycleClient();

    @Override
    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    @Override
    public void setServiceCallStats(ServiceCallStats serviceCallStats) {
    }

    @Override
    public URI getManagerURI(String bundleSymbolicNameVersion, Object service, String methodname, Class[] parameterTypes) {
        Set<URL> allManagers;
        List<URL> managersWithDeployedBundles;
        List<URL> managersWithInstalledBundles;
        List<URL> managerURLs = this.getManagersWithActiveBundle(bundleSymbolicNameVersion);
        if (managerURLs.isEmpty() && !(managersWithInstalledBundles = this.getManagersWithInstalledBundle(bundleSymbolicNameVersion)).isEmpty()) {
            managerURLs.addAll(this.bundleLifecycleClient.startBundle(managersWithInstalledBundles, bundleSymbolicNameVersion));
        }
        if (managerURLs.isEmpty() && !(managersWithDeployedBundles = this.getManagersWithDeployedBundle(bundleSymbolicNameVersion)).isEmpty()) {
            managerURLs.addAll(this.bundleLifecycleClient.installAndStartBundle(managersWithDeployedBundles, bundleSymbolicNameVersion));
        }
        if (managerURLs.isEmpty() && !(allManagers = this.registry.getGrid().getManagers()).isEmpty()) {
            managerURLs.addAll(this.bundleLifecycleClient.installAndStartBundle(allManagers, bundleSymbolicNameVersion));
        }
        if (!managerURLs.isEmpty()) {
            try {
                return managerURLs.get(0).toURI();
            }
            catch (URISyntaxException e) {
                LOG.error(e.toString(), e);
            }
        }
        return null;
    }

    private List<URL> getManagersWithInstalledBundle(String bundleSymbolicNameVersion) {
        ArrayList<URL> managerURLs = new ArrayList<URL>();
        managerURLs.addAll(this.registry.getGrid().getManagers(bundleSymbolicNameVersion, 4));
        managerURLs.addAll(this.registry.getGrid().getManagers(bundleSymbolicNameVersion, 2));
        return managerURLs;
    }

    private List<URL> getManagersWithActiveBundle(String bundleSymbolicNameVersion) {
        ArrayList<URL> managerURLs = new ArrayList<URL>();
        managerURLs.addAll(this.registry.getGrid().getManagers(bundleSymbolicNameVersion, 32));
        return managerURLs;
    }

    private List<URL> getManagersWithDeployedBundle(String bundleSymbolicNameVersion) {
        ArrayList<URL> managerURLs = new ArrayList<URL>();
        managerURLs.addAll(this.registry.getGrid().getManagers(bundleSymbolicNameVersion, 1));
        return managerURLs;
    }
}

