/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.repository.impl;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import org.bundlebee.registry.impl.RegistryImpl;
import org.bundlebee.repository.Repository;
import org.bundlebee.repository.impl.Activator;
import org.bundlebee.repository.impl.SimpleFileHttpContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceReference;
import org.osgi.impl.bundle.obr.resource.BundleInfo;
import org.osgi.impl.bundle.obr.resource.ResourceImpl;
import org.osgi.impl.bundle.obr.resource.Tag;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;
import org.osgi.service.http.NamespaceException;
import org.osgi.service.obr.Resource;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryImpl
implements Repository {
    private static Logger LOG = LoggerFactory.getLogger(RepositoryImpl.class);
    public static final String ORG_BUNDLEBEE_REPOSITORY_ROOT = "org.bundlebee.repository.root";
    public static final String ORG_BUNDLEBEE_REPOSITORY_ALIAS = "org.bundlebee.repository.alias";
    private static final String ORG_BUNDLEBEE_REGISTRY_LOCALADDRESS = "org.bundlebee.registry.localaddress";
    private static final String ORG_BUNDLEBEE_REPOSITORY_LOCALADDRESS = "org.bundlebee.repository.localaddress";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String DEFAULT_REPOSITORY_ROOT = new File("repository").toString();
    private static final String DEFAULT_BUNDLEBEE_REPOSITORY_ALIAS = "/bundlebee/repository";
    private static final int DEFAULT_PORT = 8080;
    private static final String REPOSITORY_XML = "repository.xml";
    private String localAddress = System.getProperty("org.bundlebee.repository.localaddress", System.getProperty("org.bundlebee.registry.localaddress", InetAddress.getLocalHost().getHostAddress()));
    private ServiceTracker httpServiceTracker;
    private Integer port;
    private BundleListener bundleListener;
    private BundleContext bundleContext;

    public RepositoryImpl(BundleContext bundleContext) throws Exception {
        this.bundleContext = bundleContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug(Activator.BUNDLE_MARKER, "Starting BundleBee repository...");
        }
        File repositoryRoot = RepositoryImpl.getRepositoryRootDir();
        if (LOG.isDebugEnabled()) {
            LOG.debug(Activator.BUNDLE_MARKER, "Repository root : " + repositoryRoot);
        }
        String repositoryAlias = this.getRepositoryAlias();
        if (LOG.isDebugEnabled()) {
            LOG.debug(Activator.BUNDLE_MARKER, "Repository alias: " + repositoryAlias);
        }
        this.indexRepository(repositoryRoot);
        this.httpServiceTracker = new HttpServiceTracker(bundleContext, repositoryRoot, repositoryAlias);
        this.httpServiceTracker.open();
        this.bundleListener = new BundleListener(){

            public void bundleChanged(BundleEvent event) {
                ArrayList<Bundle> list = new ArrayList<Bundle>();
                list.add(event.getBundle());
                try {
                    RepositoryImpl.this.install(list);
                }
                catch (Exception e) {
                    LOG.error(e.toString(), (Throwable)e);
                }
            }
        };
        bundleContext.addBundleListener(this.bundleListener);
        try {
            this.install(Arrays.asList(bundleContext.getBundles()));
        }
        catch (Exception e) {
            LOG.error(e.toString(), (Throwable)e);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(Activator.BUNDLE_MARKER, "BundleBee repository started.");
        }
    }

    public void stop() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(Activator.BUNDLE_MARKER, "Stopping BundleBee repository...");
        }
        this.httpServiceTracker.close();
        this.bundleContext.removeBundleListener(this.bundleListener);
        if (LOG.isDebugEnabled()) {
            LOG.debug(Activator.BUNDLE_MARKER, "BundleBee repository stopped.");
        }
    }

    @Override
    public synchronized void install(File resourceFile) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(Activator.BUNDLE_MARKER, "Installing resource from path " + resourceFile.getAbsolutePath());
        }
        if (!resourceFile.toString().toLowerCase().endsWith(JAR_FILE_EXTENSION)) {
            throw new IllegalArgumentException("Bundle filename must be a JAR.");
        }
        File rootFile = new File(RepositoryImpl.getRepositoryRootDir().getAbsolutePath() + "/");
        File to = new File(rootFile, resourceFile.getName());
        if (!to.getCanonicalFile().equals(resourceFile.getCanonicalFile())) {
            RepositoryImpl.copy(resourceFile, to);
            this.indexRepository(rootFile);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(Activator.BUNDLE_MARKER, "Resource " + resourceFile + " is already in this repository.");
        }
    }

    @Override
    public synchronized void install(URL resourceURL, String name) throws Exception {
        if (LOG.isDebugEnabled()) {
            LOG.debug(Activator.BUNDLE_MARKER, "Installing resource from URL " + resourceURL);
        }
        if (!name.toLowerCase().endsWith(JAR_FILE_EXTENSION)) {
            throw new IllegalArgumentException("Bundle filename must be a JAR.");
        }
        File rootFile = new File(RepositoryImpl.getRepositoryRootDir().getAbsolutePath() + "/");
        File to = new File(rootFile, name);
        if (!to.exists()) {
            RepositoryImpl.copy(resourceURL, to);
            this.indexRepository(rootFile);
        } else if (LOG.isDebugEnabled()) {
            LOG.debug(Activator.BUNDLE_MARKER, "A resource with the same name as " + name + " already exists.");
        }
    }

    private synchronized void install(Collection<Bundle> bundles) throws Exception {
        File rootFile = new File(RepositoryImpl.getRepositoryRootDir().getAbsolutePath() + "/");
        boolean installedNewFile = false;
        for (Bundle bundle : bundles) {
            String name = bundle.getSymbolicName() + "_" + bundle.getHeaders().get("Bundle-Version") + JAR_FILE_EXTENSION;
            if (LOG.isDebugEnabled()) {
                LOG.debug(Activator.BUNDLE_MARKER, "Installing resource named " + name + " from location " + bundle.getLocation());
            }
            String location = bundle.getLocation();
            location = this.removeInitialReferenceProtocol(location);
            try {
                URL locationURL = new URL(location);
                File to = new File(rootFile, name);
                if (!to.exists()) {
                    RepositoryImpl.copy(locationURL, to);
                    installedNewFile = true;
                    continue;
                }
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(Activator.BUNDLE_MARKER, "A resource with the same name as " + name + " already exists.");
            }
            catch (MalformedURLException e) {
                LOG.info(Activator.BUNDLE_MARKER, "Unable to copy bundle from location " + bundle.getLocation() + ": " + e.toString());
            }
            catch (Exception e) {
                LOG.error(Activator.BUNDLE_MARKER, e.toString(), (Throwable)e);
            }
        }
        if (installedNewFile) {
            this.indexRepository(rootFile);
        }
    }

    private String removeInitialReferenceProtocol(String location) {
        if (location != null && location.startsWith("initial@reference:") && location.endsWith("/")) {
            location = location.substring("initial@reference:".length(), location.length() - 1);
        } else if (location != null && location.startsWith("initial@reference:")) {
            location = location.substring("initial@reference:".length());
        }
        return location;
    }

    private void indexRepository(File root) throws Exception {
        URL rootURL = root.toURL();
        org.osgi.impl.bundle.obr.resource.RepositoryImpl osgiRepository = new org.osgi.impl.bundle.obr.resource.RepositoryImpl(rootURL);
        List<Resource> resources = this.getRepositoryResources(root, osgiRepository);
        Tag xmlRepository = this.buildXmlRepository(resources);
        File tempRepositoryFile = new File(RepositoryImpl.getRepositoryRootDir(), "repository.xml.tmp");
        File repositoryFile = new File(RepositoryImpl.getRepositoryRootDir(), REPOSITORY_XML);
        File bakRepositoryFile = new File(RepositoryImpl.getRepositoryRootDir(), "repository.xml.bak");
        this.writeRepository(xmlRepository, tempRepositoryFile);
        repositoryFile.renameTo(bakRepositoryFile);
        tempRepositoryFile.renameTo(repositoryFile);
    }

    private List<Resource> getRepositoryResources(File rootFile, org.osgi.impl.bundle.obr.resource.RepositoryImpl osgiRepository) throws Exception {
        File[] jarFiles = rootFile.listFiles(new FileFilter(){

            public boolean accept(File pathname) {
                return pathname.getName().toLowerCase().endsWith(RepositoryImpl.JAR_FILE_EXTENSION);
            }
        });
        ArrayList<Resource> resources = new ArrayList<Resource>();
        for (File jarFile : jarFiles) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding resource " + jarFile + " to " + REPOSITORY_XML + "...");
            }
            BundleInfo info = new BundleInfo(osgiRepository, jarFile);
            ResourceImpl resource = info.build();
            resource.setURL(jarFile.toURL());
            resources.add(resource);
        }
        Collections.sort(resources, new SymbolicNameComparator());
        return resources;
    }

    private Tag buildXmlRepository(List<Resource> resources) {
        Tag xmlRepository = new Tag("repository");
        xmlRepository.addAttribute("lastmodified", new Date());
        xmlRepository.addAttribute("name", "BundleBee Repository " + RegistryImpl.getInstance().getNodeId());
        for (Resource resource : resources) {
            ResourceImpl resourceImpl = (ResourceImpl)resource;
            xmlRepository.addContent(resourceImpl.toXML());
        }
        return xmlRepository;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeRepository(Tag xmlRepository, File repositoryFile) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
        pw.println("<?xml version='1.0' encoding='utf-8'?>");
        pw.println("<?xml-stylesheet type='text/xsl' href='http://www2.osgi.org/www/obr2html.xsl'?>");
        xmlRepository.print(0, pw);
        pw.close();
        byte[] buffer = out.toByteArray();
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(repositoryFile);
            fileOutputStream.write(buffer);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException e) {
                    LOG.error(e.toString(), (Throwable)e);
                }
            }
        }
    }

    private static File getRepositoryRootDir() throws FileNotFoundException {
        String repositoryPath = System.getProperty(ORG_BUNDLEBEE_REPOSITORY_ROOT, DEFAULT_REPOSITORY_ROOT).trim();
        if (repositoryPath != null && repositoryPath.startsWith("~")) {
            repositoryPath = System.getProperty("user.home") + repositoryPath.substring(1);
        }
        File repositoryRoot = new File(repositoryPath);
        repositoryRoot.mkdirs();
        if (!repositoryRoot.exists()) {
            throw new FileNotFoundException("Repository root " + repositoryRoot + " does not exist.");
        }
        if (!repositoryRoot.canRead()) {
            throw new FileNotFoundException("Repository root " + repositoryRoot + " is not readable.");
        }
        return repositoryRoot;
    }

    private String getRepositoryAlias() {
        return System.getProperty(ORG_BUNDLEBEE_REPOSITORY_ALIAS, DEFAULT_BUNDLEBEE_REPOSITORY_ALIAS);
    }

    @Override
    public URL getRepositoryURL() {
        if (this.port == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(Activator.BUNDLE_MARKER, "Port is null");
            }
            return null;
        }
        try {
            return new URL("http://" + this.localAddress + ":" + this.port + this.getRepositoryAlias() + "/" + REPOSITORY_XML);
        }
        catch (MalformedURLException e) {
            LOG.error(Activator.BUNDLE_MARKER, e.toString(), (Throwable)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(File from, File to) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            long transferred;
            in = new FileInputStream(from);
            out = new FileOutputStream(to);
            long inPos = 0L;
            FileChannel inChannel = in.getChannel();
            FileChannel outChannel = out.getChannel();
            for (long count = from.length(); count != 0L; count -= transferred) {
                transferred = inChannel.transferTo(inPos, count, outChannel);
                inChannel.position(inPos += transferred);
            }
            to.setLastModified(from.lastModified());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.error(e.toString(), (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOG.error(e.toString(), (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copy(URL from, File to) throws IOException {
        InputStream in = null;
        FileOutputStream out = null;
        try {
            int lastRead;
            URLConnection urlConnection = from.openConnection();
            in = urlConnection.getInputStream();
            out = new FileOutputStream(to);
            byte[] buf = new byte[65536];
            while ((lastRead = in.read(buf)) != -1) {
                out.write(buf, 0, lastRead);
            }
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    LOG.error(e.toString(), (Throwable)e);
                }
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException e) {
                    LOG.error(e.toString(), (Throwable)e);
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SymbolicNameComparator
    implements Comparator<Resource> {
        private SymbolicNameComparator() {
        }

        @Override
        public int compare(Resource r1, Resource r2) {
            String s1 = this.getSymbolicName(r1);
            String s2 = this.getSymbolicName(r2);
            return s1.compareTo(s2);
        }

        private String getSymbolicName(Resource resource) {
            String s = resource.getSymbolicName();
            return s == null ? "no-symbolic-name" : s;
        }
    }

    private class HttpServiceTracker
    extends ServiceTracker {
        private final BundleContext bundleContext;
        private final File repositoryRoot;
        private final String repositoryAlias;

        public HttpServiceTracker(BundleContext bundleContext, File repositoryRoot, String repositoryAlias) {
            super(bundleContext, HttpService.class.getName(), null);
            this.bundleContext = bundleContext;
            this.repositoryRoot = repositoryRoot;
            this.repositoryAlias = repositoryAlias;
        }

        public Object addingService(ServiceReference serviceReference) {
            Integer port = (Integer)serviceReference.getProperty("http.port");
            if (port == null) {
                RepositoryImpl.this.port = 8080;
            } else {
                RepositoryImpl.this.port = port;
            }
            HttpService httpService = (HttpService)this.bundleContext.getService(serviceReference);
            if (httpService != null) {
                try {
                    SimpleFileHttpContext simpleFileHttpContext = new SimpleFileHttpContext(httpService.createDefaultHttpContext(), this.repositoryRoot);
                    httpService.registerResources(this.repositoryAlias, this.repositoryRoot.toString(), (HttpContext)simpleFileHttpContext);
                    this.registerAtDistributedRegistry();
                }
                catch (IOException e) {
                    LOG.error(Activator.BUNDLE_MARKER, e.toString(), (Throwable)e);
                }
                catch (NamespaceException e) {
                    LOG.error(Activator.BUNDLE_MARKER, e.toString(), (Throwable)e);
                }
            }
            return httpService;
        }

        private void registerAtDistributedRegistry() {
            URL repositoryURL = RepositoryImpl.this.getRepositoryURL();
            if (repositoryURL != null) {
                RegistryImpl.getInstance().registerRepository(repositoryURL);
            }
        }

        public void removedService(ServiceReference serviceReference, Object o) {
            this.unregisterFromDistributedRegistry();
            HttpService httpService = (HttpService)o;
            if (httpService != null) {
                httpService.unregister(RepositoryImpl.DEFAULT_BUNDLEBEE_REPOSITORY_ALIAS);
            }
            RepositoryImpl.this.port = null;
        }

        private void unregisterFromDistributedRegistry() {
            URL repositoryURL = RepositoryImpl.this.getRepositoryURL();
            if (repositoryURL != null) {
                RegistryImpl.getInstance().unregisterRepository(repositoryURL);
            }
        }

        public synchronized void close() {
            RepositoryImpl.this.port = null;
            this.unregisterFromDistributedRegistry();
            super.close();
        }
    }
}

