/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.bindex;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.CRC32;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.osgi.impl.bundle.obr.resource.BundleInfo;
import org.osgi.impl.bundle.obr.resource.RepositoryImpl;
import org.osgi.impl.bundle.obr.resource.ResourceImpl;
import org.osgi.impl.bundle.obr.resource.Tag;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Index {
    String repositoryFileName = "repository.xml";
    URL licenseURL = null;
    boolean quiet = false;
    String name = "Untitled";
    boolean ignoreFlag = false;
    String urlTemplate = null;
    URL root;
    RepositoryImpl repository;
    String stylesheet = "http://www.osgi.org/www/obr2html.xsl";

    public static void main(String[] args) throws Exception {
        Index index = new Index();
        index.run(args);
    }

    protected void run(String[] args) throws Exception {
        System.err.println("Bundle Indexer | v2.2");
        System.err.println("(c) 2007 OSGi, All Rights Reserved");
        HashSet<ResourceImpl> resources = new HashSet<ResourceImpl>();
        this.root = new File("").getAbsoluteFile().toURI().toURL();
        this.repository = new RepositoryImpl(this.root);
        int i = 0;
        while (i < args.length) {
            try {
                if (args[i].startsWith("-n")) {
                    this.name = args[++i];
                } else if (args[i].equals("-stylesheet")) {
                    this.stylesheet = args[++i];
                } else if (args[i].startsWith("-r")) {
                    this.repositoryFileName = args[++i];
                    this.repository = new RepositoryImpl(new File(this.repositoryFileName).getAbsoluteFile().toURI().toURL());
                } else if (args[i].startsWith("-q")) {
                    this.quiet = true;
                } else if (args[i].startsWith("-d")) {
                    this.root = new File(args[++i]).toURI().toURL();
                } else if (args[i].startsWith("-t")) {
                    this.urlTemplate = args[++i];
                } else if (args[i].startsWith("-l")) {
                    this.licenseURL = new URL(new File("").toURI().toURL(), args[++i]);
                } else if (args[i].startsWith("-i")) {
                    this.ignoreFlag = true;
                } else if (args[i].startsWith("-help")) {
                    System.err.println("bindex [-t \"%s\" symbolic name \"%v\" version \"%f\" filename \"%p\" dirpath ]\n[-d rootFile]\n[ -r repository.(xml|zip) ]\n[-help]\n[-ignore] #ignore exceptions when no manifest\n[-l file:license.html ]\n[-quiet]\n[-stylesheet " + this.stylesheet + "  ]\n" + "<jar file>*");
                } else {
                    this.recurse(resources, new File(args[i]));
                }
            }
            catch (Exception e) {
                System.err.println("Error in " + args[i] + " : " + e.getMessage());
                e.printStackTrace();
            }
            ++i;
        }
        ArrayList<ResourceImpl> sorted = new ArrayList<ResourceImpl>(resources);
        Collections.sort(sorted, new Comparator<ResourceImpl>(){

            @Override
            public int compare(ResourceImpl r1, ResourceImpl r2) {
                String s1 = Index.this.getName(r1);
                String s2 = Index.this.getName(r2);
                return s1.compareTo(s2);
            }
        });
        Tag tag = this.doIndex(sorted);
        if (this.repositoryFileName != null) {
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)out, "UTF-8"));
            pw.println("<?xml version='1.0' encoding='utf-8'?>");
            pw.println("<?xml-stylesheet type='text/xsl' href='" + this.stylesheet + "'?>");
            tag.print(0, pw);
            pw.close();
            byte[] buffer = out.toByteArray();
            String name = "repository.xml";
            FileOutputStream fout = new FileOutputStream(this.repositoryFileName);
            if (this.repositoryFileName.endsWith(".zip")) {
                ZipOutputStream zip = new ZipOutputStream(fout);
                CRC32 checksum = new CRC32();
                checksum.update(buffer);
                ZipEntry ze = new ZipEntry(name);
                ze.setSize(buffer.length);
                ze.setCrc(checksum.getValue());
                zip.putNextEntry(ze);
                zip.write(buffer, 0, buffer.length);
                zip.closeEntry();
                zip.close();
            } else {
                fout.write(buffer);
            }
            fout.close();
        }
        if (!this.quiet) {
            PrintWriter pw = new PrintWriter(new OutputStreamWriter(System.out));
            pw.println("<?xml version='1.0' encoding='utf-8'?>");
            pw.println("<?xml-stylesheet type='text/xsl' href='" + this.stylesheet + "'?>");
            tag.print(0, pw);
            pw.close();
        }
    }

    String getName(ResourceImpl impl) {
        String s = impl.getSymbolicName();
        if (s != null) {
            return s;
        }
        return "no-symbolic-name";
    }

    void recurse(Set<ResourceImpl> resources, File path) throws Exception {
        block7: {
            block6: {
                if (!path.isDirectory()) break block6;
                String[] list = path.list();
                int i = 0;
                while (i < list.length) {
                    this.recurse(resources, new File(path, list[i]));
                    ++i;
                }
                break block7;
            }
            if (!path.getName().endsWith("ar")) break block7;
            try {
                BundleInfo info = new BundleInfo(this.repository, path);
                ResourceImpl resource = info.build();
                if (this.urlTemplate != null) {
                    this.doTemplate(path, resource);
                } else {
                    resource.setURL(path.toURI().toURL());
                }
                resources.add(resource);
            }
            catch (Exception e) {
                if (!this.ignoreFlag) {
                    throw e;
                }
                System.err.println("Ignoring: " + path.getName() + " with exception " + e.getMessage());
            }
        }
    }

    void doTemplate(File path, ResourceImpl resource) throws MalformedURLException {
        String dir = path.getAbsoluteFile().getParentFile().getAbsoluteFile().toURI().toURL().toString();
        if (dir.endsWith("/")) {
            dir = dir.substring(0, dir.length() - 1);
        }
        if (dir.startsWith(this.root.toString())) {
            dir = dir.substring(this.root.toString().length());
        }
        String url = this.urlTemplate.replaceAll("%v", "" + resource.getVersion());
        url = url.replaceAll("%s", resource.getSymbolicName());
        url = url.replaceAll("%f", path.getName());
        url = url.replaceAll("%p", dir);
        resource.setURL(new URL(url));
    }

    Tag doIndex(Collection<ResourceImpl> resources) throws IOException {
        Tag repository = new Tag("repository");
        repository.addAttribute("lastmodified", new Date());
        repository.addAttribute("name", this.name);
        for (ResourceImpl resource : resources) {
            repository.addContent(resource.toXML());
        }
        return repository;
    }

    void addToZip(ZipOutputStream zip, String name, InputStream actual) throws IOException {
        byte[] buffer = this.readAll(actual, 0);
        actual.close();
        CRC32 checksum = new CRC32();
        checksum.update(buffer);
        ZipEntry ze = new ZipEntry(name);
        ze.setSize(buffer.length);
        ze.setCrc(checksum.getValue());
        zip.putNextEntry(ze);
        zip.write(buffer, 0, buffer.length);
        zip.closeEntry();
    }

    byte[] readAll(InputStream in, int offset) throws IOException {
        byte[] temp = new byte[4096];
        int size = in.read(temp, 0, temp.length);
        if (size <= 0) {
            return new byte[offset];
        }
        byte[] result = this.readAll(in, offset + size);
        System.arraycopy(temp, 0, result, offset, size);
        return result;
    }
}

