/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.examples.fractal;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.LinkedList;
import javax.swing.JPanel;
import javax.swing.Timer;
import org.bundlebee.examples.fractal.SnapshotPanel;

public class SnapshotsPanel
extends JPanel {
    private static final int MAXSNAPSHOTS = 50;
    private static final int GAP = 2;
    private final LinkedList<SnapshotPanel> mSnapshots = new LinkedList();

    public SnapshotsPanel() {
        this.initComponents();
        this.setPreferredSize(new Dimension(48, 0));
    }

    public void addSnapshot(SnapshotPanel p) {
        if (50 <= this.mSnapshots.size()) {
            this.remove(this.mSnapshots.getLast());
            this.mSnapshots.removeLast();
        }
        this.setPreferredSize(new Dimension(48, (this.mSnapshots.size() + 1) * 50));
        this.invalidate();
        this.getParent().validate();
        this.add(p);
        Timer t = new Timer(6, null);
        t.addActionListener(new SlideInTimerAction(t, p));
        t.setRepeats(false);
        t.start();
    }

    private void initComponents() {
        this.setName("Form");
        this.setLayout(null);
    }

    class SlideInTimerAction
    implements ActionListener {
        Timer mTimer;
        int mSlideDownCounter = 0;
        int mSlideInCounter = 0;
        SnapshotPanel mNewSnapshot;
        SLIDEMODE mMode = SLIDEMODE.SLIDEDOWN;

        public SlideInTimerAction(Timer t, SnapshotPanel newsnapshot) {
            this.mTimer = t;
            this.mNewSnapshot = newsnapshot;
        }

        public void actionPerformed(ActionEvent e) {
            if (this.mMode == SLIDEMODE.SLIDEDOWN) {
                for (int i = 0; i < SnapshotsPanel.this.mSnapshots.size(); ++i) {
                    ((SnapshotPanel)SnapshotsPanel.this.mSnapshots.get(i)).setLocation(0, i * 50 + this.mSlideDownCounter);
                }
                this.mNewSnapshot.setLocation(this.mSlideDownCounter - 48 - 2, 0);
                ++this.mSlideDownCounter;
                if (this.mSlideDownCounter <= 50) {
                    this.mTimer.restart();
                } else {
                    SnapshotsPanel.this.mSnapshots.addFirst(this.mNewSnapshot);
                }
            }
            SnapshotsPanel.this.repaint();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SLIDEMODE {
        SLIDEDOWN,
        SLIDEIN;

    }
}

