/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.remoteservicecall;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ObjectInputStreamWithServiceClassLoader
extends ObjectInputStream {
    private ClassLoader mClassLoader;
    private final BundleContext mContext;

    public ObjectInputStreamWithServiceClassLoader(InputStream in, BundleContext ctx) throws IOException {
        this(in, null, ctx);
    }

    public ObjectInputStreamWithServiceClassLoader(InputStream in, ClassLoader cl) throws IOException {
        this(in, cl, null);
    }

    public ObjectInputStreamWithServiceClassLoader(InputStream in, ClassLoader classloader, BundleContext ctx) throws IOException {
        super(in);
        this.mClassLoader = null == classloader ? this.getClass().getClassLoader() : classloader;
        this.mContext = ctx;
    }

    public void useClassLoader(ClassLoader cl) {
        this.mClassLoader = cl;
    }

    @Override
    protected Class<?> resolveClass(ObjectStreamClass desc) throws ClassNotFoundException {
        try {
            return Class.forName(desc.getName(), true, this.mClassLoader);
        }
        catch (ClassNotFoundException ex) {
            return Class.forName(desc.getName());
        }
    }

    BundleContext getBundleContext() {
        return this.mContext;
    }
}

