/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.examples.fractal;

import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import org.bundlebee.examples.fractal.AsynchronousContentRequest;
import org.bundlebee.examples.fractal.BufferedImageProvider;
import org.bundlebee.examples.fractal.ContentProvider;
import org.bundlebee.examples.fractal.EffectManager;
import org.bundlebee.examples.fractal.GlowingBorderEffect;
import org.bundlebee.examples.fractal.ZoomRectangle;

public class BufferedImagePanel
extends JPanel {
    private final BufferedImageProvider mImageProvider;
    private final ContentProvider mContentProvider;
    private BufferedImage mImage = null;
    private ZoomRectangle mZoom = new ZoomRectangle();
    private final List<ZoomListener> mZoomListeners = new ArrayList<ZoomListener>();
    private AsynchronousContentRequest.Observer mRequestObserver = null;
    private final ThreadGroup mThreadGroup = new ThreadGroup("AsynchronousContentRequest");
    private AsynchronousContentRequest mLastContentRequest = null;
    private final EffectManager mEffects = new EffectManager(this);

    public BufferedImagePanel(BufferedImageProvider imageprovider, ContentProvider contentprovider) {
        this.mImageProvider = imageprovider;
        this.mContentProvider = contentprovider;
        this.addComponentListener(new ComponentListener(){

            public void componentResized(ComponentEvent e) {
                BufferedImagePanel.this.mImage = BufferedImagePanel.this.mImageProvider.get(BufferedImagePanel.this, BufferedImagePanel.this.mImage);
                Rectangle r = new Rectangle(BufferedImagePanel.this.getSize());
                BufferedImagePanel.this.repaint(r);
                BufferedImagePanel.this.requestContentProvider(new AsynchronousContentRequest(BufferedImagePanel.this, BufferedImagePanel.this.mImage, new Rectangle[]{r}, BufferedImagePanel.this.mRequestObserver));
            }

            public void componentMoved(ComponentEvent e) {
            }

            public void componentShown(ComponentEvent e) {
            }

            public void componentHidden(ComponentEvent e) {
            }
        });
        MouseAdapter ma = new MouseAdapter(){
            boolean mIsDragging = false;

            public void mousePressed(MouseEvent e) {
                super.mousePressed(e);
                BufferedImagePanel.this.mZoom.setLocation(e.getPoint());
                BufferedImagePanel.this.mZoom.setSize(0, 0);
                BufferedImagePanel.this.mZoom.setVisible(true);
                BufferedImagePanel.this.repaint(BufferedImagePanel.this.mZoom);
                this.mIsDragging = true;
            }

            public void mouseReleased(MouseEvent e) {
                super.mouseReleased(e);
                this.mIsDragging = false;
                BufferedImagePanel.this.mZoom.setVisible(false);
                BufferedImagePanel.this.repaint(BufferedImagePanel.this.mZoom);
                for (ZoomListener l : BufferedImagePanel.this.mZoomListeners) {
                    l.zoomTo(BufferedImagePanel.this.mZoom);
                }
            }
        };
        MouseMotionAdapter mma = new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent e) {
                BufferedImagePanel.this.repaint(BufferedImagePanel.this.mZoom);
                BufferedImagePanel.this.mZoom.setSize(e.getX() - ((BufferedImagePanel)BufferedImagePanel.this).mZoom.x, e.getY() - ((BufferedImagePanel)BufferedImagePanel.this).mZoom.y);
                BufferedImagePanel.this.repaint(BufferedImagePanel.this.mZoom);
            }
        };
        this.addMouseListener(ma);
        this.addMouseMotionListener(mma);
    }

    public void addZoomListener(ZoomListener l) {
        this.mZoomListeners.add(l);
    }

    public void removeZoomListener(ZoomListener l) {
        this.mZoomListeners.remove(l);
    }

    public BufferedImage getImage() {
        return this.mImage;
    }

    public void setRequestObserver(AsynchronousContentRequest.Observer obs) {
        this.mRequestObserver = obs;
    }

    void requestContentProvider(final AsynchronousContentRequest r) {
        if (null != this.mLastContentRequest) {
            this.mLastContentRequest.cancel();
        }
        this.mThreadGroup.interrupt();
        this.mLastContentRequest = r;
        Thread contentthread = new Thread(this.mThreadGroup, new Runnable(){

            public void run() {
                BufferedImagePanel.this.mContentProvider.request(r);
            }
        });
        contentthread.start();
    }

    public void updateContent() {
        if (null != this.mImage) {
            this.requestContentProvider(new AsynchronousContentRequest(this, this.mImage, new Rectangle[]{this.getBounds()}, this.mRequestObserver));
        }
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.mImage, 0, 0, null);
        Graphics2D g2 = (Graphics2D)g.create();
        this.mEffects.display(g2);
        g2.dispose();
        g2 = (Graphics2D)g.create();
        this.mZoom.display(g2);
        g2.dispose();
    }

    void update(Rectangle r, boolean intermediate) {
        if (!intermediate) {
            this.mEffects.addEffect(new GlowingBorderEffect(r));
        }
        this.repaint(r);
    }

    public static interface ZoomListener {
        public void zoomTo(Rectangle var1);
    }
}

