/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.examples.fractal;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;

public class GlowingRoundRect {
    public static void paint(Graphics2D g2, Rectangle rect, int arc, Color color, int glowWidth, float opacity) {
        int gw = glowWidth * 2;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(color);
        for (int i = gw; i >= 2; i -= 2) {
            float pct = (float)(gw - i) / (float)(gw - 1);
            g2.setComposite(AlphaComposite.getInstance(10, pct * opacity));
            g2.setStroke(new BasicStroke(i));
            g2.drawRoundRect(rect.x + glowWidth, rect.y + glowWidth, rect.width - gw, rect.height - gw, arc, arc);
        }
    }
}

