/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.registry.directory;

import java.net.InetAddress;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bundlebee.registry.directory.Bundle;
import org.bundlebee.registry.directory.Grid;
import org.bundlebee.registry.impl.RegistryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Node {
    private long id;
    private URL managerURL;
    private URL repositoryURL;
    private long freeMemory;
    private long maxMemory;
    private InetAddress privateAddress;
    private int privatePort;
    private Map<String, Bundle> bundles = new ConcurrentHashMap<String, Bundle>();
    private Grid grid;

    Node(Grid grid, long id) {
        this.grid = grid;
        this.id = id;
    }

    Bundle newBundle(String name, int state) {
        return new Bundle(this, name, state);
    }

    Grid getGrid() {
        return this.grid;
    }

    public long getId() {
        return this.id;
    }

    public boolean isLocalNode() {
        return this.id == RegistryImpl.getInstance().getNodeId();
    }

    public URL getManagerURL() {
        return this.managerURL;
    }

    void setManagerURL(URL managerURL) {
        URL oldURL = this.managerURL;
        if (managerURL == null && oldURL != null && this.grid != null) {
            this.grid.unregisterManager(this);
            this.managerURL = managerURL;
        }
        if (managerURL != null && oldURL == null && this.grid != null) {
            this.managerURL = managerURL;
            this.grid.registerManager(this);
        }
        if (managerURL != null && !managerURL.equals(oldURL) && this.grid != null) {
            this.grid.unregisterManager(this);
            this.managerURL = managerURL;
            this.grid.registerManager(this);
        }
    }

    public URL getRepositoryURL() {
        return this.repositoryURL;
    }

    void setRepositoryURL(URL repositoryURL) {
        this.repositoryURL = repositoryURL;
    }

    public long getFreeMemory() {
        return this.freeMemory;
    }

    void setFreeMemory(long freeMemory) {
        this.freeMemory = freeMemory;
    }

    public long getMaxMemory() {
        return this.maxMemory;
    }

    void setMaxMemory(long maxMemory) {
        this.maxMemory = maxMemory;
    }

    void addBundle(Bundle bundle) {
        Bundle removedBundle = this.bundles.put(bundle.getName(), bundle);
        if (removedBundle != null) {
            this.grid.unregister(removedBundle);
        }
        this.grid.register(bundle);
    }

    boolean removeBundle(Bundle bundle) {
        return this.removeBundle(bundle.getName());
    }

    boolean removeBundle(String bundleName) {
        Bundle removedBundle = this.bundles.remove(bundleName);
        if (removedBundle != null) {
            this.grid.unregister(removedBundle);
        }
        return removedBundle != null;
    }

    public Collection<Bundle> getBundles() {
        return Collections.unmodifiableCollection(this.bundles.values());
    }

    public InetAddress getPrivateAddress() {
        return this.privateAddress;
    }

    void setPrivateAddress(InetAddress privateAddress) {
        this.privateAddress = privateAddress;
    }

    public int getPrivatePort() {
        return this.privatePort;
    }

    void setPrivatePort(int privatePort) {
        this.privatePort = privatePort;
    }

    public String getPrivateAddressAndPort() {
        String address = this.privateAddress != null && this.privatePort != 0 ? this.privateAddress.getHostAddress() + ":" + this.privatePort : null;
        return address;
    }

    public String toString() {
        return "Node[id=" + this.id + ",manager=" + this.managerURL + ",repository=" + this.repositoryURL + ",memory=" + this.freeMemory + "/" + this.maxMemory + ",bundles=" + this.bundles.size() + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FreeMemoryComparator
    implements Comparator<Node> {
        @Override
        public int compare(Node node1, Node node2) {
            return Long.valueOf(node1.freeMemory).compareTo(node2.freeMemory);
        }
    }
}

