/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.weaver.equinox;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import javassist.CtMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstrumentedMethods {
    private static Logger LOG = LoggerFactory.getLogger(InstrumentedMethods.class);
    private static final Set<Pattern> INSTRUMENTED_METHODS;
    private static final String ORG_BUNDLEBEE_WEAVER_INSTRUMENTEDMETHODS = "org.bundlebee.weaver.instrumentedmethods";

    private static Set<Pattern> readInstrumentedMethods() throws IOException {
        String systemProperty;
        File file = new File("bundlebee.ini");
        HashSet<Pattern> set = new HashSet<Pattern>();
        if (file.exists()) {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(file), "UTF-8"));
            while ((line = reader.readLine()) != null) {
                set.add(Pattern.compile(line));
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info(file + " does not exist.");
        }
        if ((systemProperty = System.getProperty(ORG_BUNDLEBEE_WEAVER_INSTRUMENTEDMETHODS)) != null) {
            String[] strings;
            for (String s : strings = systemProperty.split(";")) {
                set.add(Pattern.compile(s));
            }
        }
        return set;
    }

    private static Set<Pattern> get() {
        return INSTRUMENTED_METHODS;
    }

    public static boolean mustInstrument(CtMethod method) {
        boolean isStatic;
        boolean bl = isStatic = 0 != (method.getModifiers() & 8);
        if (isStatic) {
            return false;
        }
        String methodname = method.getLongName();
        for (Pattern pattern : InstrumentedMethods.get()) {
            if (!pattern.matcher(methodname).matches()) continue;
            return true;
        }
        return false;
    }

    static {
        Set<Object> set = new HashSet();
        try {
            set = InstrumentedMethods.readInstrumentedMethods();
        }
        catch (IOException e) {
            LOG.error(e.toString(), e);
        }
        INSTRUMENTED_METHODS = set;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Instrumented method patterns: " + INSTRUMENTED_METHODS);
        }
    }
}

