/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.repository.impl;

import java.util.Dictionary;
import java.util.Properties;
import org.bundlebee.repository.Repository;
import org.bundlebee.repository.impl.RepositoryImpl;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class Activator
implements BundleActivator {
    private static Logger LOG = LoggerFactory.getLogger(Activator.class);
    public static final String ID = "org.bundlebee.repository";
    public static final Marker BUNDLE_MARKER = Activator.createBundleMarker();
    private RepositoryImpl repository;

    private static Marker createBundleMarker() {
        Marker bundleMarker = MarkerFactory.getMarker((String)ID);
        bundleMarker.add(MarkerFactory.getMarker((String)"IS_MARKER"));
        return bundleMarker;
    }

    public void start(BundleContext context) throws Exception {
        this.repository = new RepositoryImpl(context);
        if (LOG.isInfoEnabled()) {
            LOG.info(BUNDLE_MARKER, "Starting BundleBee repository...");
        }
        Properties properties = new Properties();
        context.registerService(Repository.class.getName(), (Object)this.repository, (Dictionary)properties);
    }

    public void stop(BundleContext context) throws Exception {
        this.repository.stop();
        if (LOG.isInfoEnabled()) {
            LOG.info(BUNDLE_MARKER, "Stopping BundleBee repository...");
        }
    }
}

