/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.carrier.impl;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.bundlebee.carrier.Carrier;
import org.bundlebee.carrier.DeploymentException;
import org.bundlebee.carrier.ResourceNotFoundException;
import org.bundlebee.carrier.UnsatisfiedRequirementsException;
import org.bundlebee.carrier.impl.Activator;
import org.bundlebee.registry.impl.RegistryImpl;
import org.bundlebee.repository.Repository;
import org.osgi.framework.BundleContext;
import org.osgi.service.obr.RepositoryAdmin;
import org.osgi.service.obr.Requirement;
import org.osgi.service.obr.Resolver;
import org.osgi.service.obr.Resource;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CarrierImpl
implements Carrier {
    private static final Logger LOG = LoggerFactory.getLogger(CarrierImpl.class);
    private static final String DEFAULT_REPOSITORY_ROOT = new File("repository").toString();
    public static final String ORG_BUNDLEBEE_REPOSITORY_ROOT = "org.bundlebee.repository.root";
    public static final String ORG_BUNDLEBEE_REPOSITORY_URLS = "org.bundlebee.repository.urls";
    private ServiceTracker repositoryAdminTracker;
    private ServiceTracker repositoryTracker;
    private Map<URL, Long> lastModifiedMap = new ConcurrentHashMap<URL, Long>();

    public CarrierImpl(BundleContext bundleContext) {
        this.repositoryAdminTracker = new ServiceTracker(bundleContext, RepositoryAdmin.class.getName(), null);
        this.repositoryAdminTracker.open();
        this.repositoryTracker = new ServiceTracker(bundleContext, Repository.class.getName(), null);
        this.repositoryTracker.open();
    }

    public void stop() {
        this.repositoryAdminTracker.close();
        this.repositoryTracker.close();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void deploy(String filterExpression, boolean start) throws DeploymentException {
        RepositoryAdmin repositoryAdmin;
        if (LOG.isDebugEnabled()) {
            LOG.debug(Activator.BUNDLE_MARKER, "deploy(\"" + filterExpression + "\", " + start + ")");
        }
        if ((repositoryAdmin = (RepositoryAdmin)this.repositoryAdminTracker.getService()) == null) {
            throw new DeploymentException("RepositoryAdmin not available. Make sure org.osgi.service.obr is deployed and running.");
        }
        this.addOrRefreshLocalRepository(repositoryAdmin);
        this.addOrRefreshAdditionalRepositories(repositoryAdmin);
        this.addOrRefreshAvailableRepositories(repositoryAdmin);
        this.listAllAvailableResources(repositoryAdmin);
        Resource[] resources = repositoryAdmin.discoverResources(filterExpression);
        if (resources != null && resources.length > 0) {
            Requirement[] unsatisfiedRequirements;
            Resource resource;
            if (LOG.isDebugEnabled()) {
                LOG.debug(Activator.BUNDLE_MARKER, "Found " + resources.length + " resources.");
            }
            for (Resource resource2 : resources) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(Activator.BUNDLE_MARKER, "Resource: " + resource2.getId());
            }
            Resource firstLocalResource = this.getFirstLocalResource(resources);
            Resource resource3 = resource = firstLocalResource == null ? resources[0] : firstLocalResource;
            if (LOG.isDebugEnabled()) {
                LOG.debug(Activator.BUNDLE_MARKER, "Resolving " + resource.getId() + ", " + resource.getURL());
            }
            Resolver resolver = repositoryAdmin.resolver();
            resolver.add(resource);
            boolean success = resolver.resolve();
            if (success) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(Activator.BUNDLE_MARKER, "Deploying " + resource.getId() + ", start=" + start);
                }
                resolver.deploy(start);
                this.deployRemoteResourcesToLocalRepository(resolver);
                return;
            }
            if (LOG.isWarnEnabled()) {
                LOG.warn(Activator.BUNDLE_MARKER, "Failed to resolve " + resource.getId());
            }
            Requirement[] requirementArray = unsatisfiedRequirements = resolver.getUnsatisfiedRequirements();
            int n = requirementArray.length;
            int n2 = 0;
            while (n2 < n) {
                Requirement requirement = requirementArray[n2];
                if (LOG.isWarnEnabled()) {
                    LOG.warn(Activator.BUNDLE_MARKER, "Unable to resolve: " + requirement.getName() + " " + requirement.getFilter());
                }
                ++n2;
            }
            throw new UnsatisfiedRequirementsException(resource, resolver.getUnsatisfiedRequirements());
        }
        if (!LOG.isErrorEnabled()) throw new ResourceNotFoundException(filterExpression);
        LOG.error(Activator.BUNDLE_MARKER, "Failed to find resources.");
        throw new ResourceNotFoundException(filterExpression);
    }

    private boolean isLocal(Resource resource) {
        return resource.getURL().toString().startsWith("file:");
    }

    private Resource getFirstLocalResource(Resource[] resources) {
        for (Resource resource : resources) {
            if (!this.isLocal(resource)) continue;
            return resource;
        }
        return null;
    }

    private void deployRemoteResourcesToLocalRepository(Resolver resolver) {
        HashSet<Resource> resources = new HashSet<Resource>();
        resources.addAll(Arrays.asList(resolver.getRequiredResources()));
        resources.addAll(Arrays.asList(resolver.getAddedResources()));
        resources.addAll(Arrays.asList(resolver.getOptionalResources()));
        this.deployResourcesToLocalRepository(resources);
    }

    private void deployResourcesToLocalRepository(Collection<Resource> resources) {
        for (Resource resource : resources) {
            LOG.debug(Activator.BUNDLE_MARKER, "Resource " + resource + " has url " + resource.getURL());
            if (!this.isLocal(resource)) continue;
            try {
                Repository repository = (Repository)this.repositoryTracker.getService();
                if (repository != null) {
                    repository.install(resource.getURL(), resource.getSymbolicName() + "_" + resource.getVersion() + ".jar");
                    continue;
                }
                LOG.warn(Activator.BUNDLE_MARKER, "Failed to obtain BundleBee repository.");
            }
            catch (Exception e) {
                LOG.error("Failed to install resource from " + resource.getURL() + " in local BundleBee repository.", (Throwable)e);
            }
        }
    }

    private void addOrRefreshAvailableRepositories(RepositoryAdmin repositoryAdmin) {
        for (URL url : RegistryImpl.getInstance().getGrid().getRepositories()) {
            try {
                if (!this.hasBeenModified(url) && this.isRepositoryAdded(repositoryAdmin, url)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Adding/refreshing repository " + url + " from registry.");
                }
                repositoryAdmin.addRepository(url);
            }
            catch (Exception e) {
                LOG.error(Activator.BUNDLE_MARKER, "Failed to add registry registered repository located at " + url + "\nCause: " + e, (Throwable)e);
            }
        }
    }

    private void addOrRefreshAdditionalRepositories(RepositoryAdmin repositoryAdmin) {
        String repositoryURLs = System.getProperty(ORG_BUNDLEBEE_REPOSITORY_URLS);
        if (repositoryURLs != null) {
            for (String urlString : repositoryURLs.split(",")) {
                try {
                    URL url = new URL(urlString);
                    if (!this.hasBeenModified(url) && this.isRepositoryAdded(repositoryAdmin, url)) continue;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Adding/refreshing addition repository at " + url);
                    }
                    repositoryAdmin.addRepository(url);
                }
                catch (Exception e) {
                    LOG.error(Activator.BUNDLE_MARKER, "Failed to add/refresh system property configured repository located at " + urlString + "\nCause: " + e, (Throwable)e);
                }
            }
        } else if (LOG.isInfoEnabled()) {
            LOG.info(Activator.BUNDLE_MARKER, "No additional repositories configured via system property org.bundlebee.repository.urls.");
        }
    }

    private void addOrRefreshLocalRepository(RepositoryAdmin repositoryAdmin) {
        try {
            URL url = new File(CarrierImpl.getRepositoryRoot().toString() + "/repository.xml").toURL();
            if (this.hasBeenModified(url) || !this.isRepositoryAdded(repositoryAdmin, url)) {
                LOG.debug(Activator.BUNDLE_MARKER, "Adding/refreshing local repository " + url.toString());
                repositoryAdmin.addRepository(url);
            }
        }
        catch (Exception e) {
            LOG.error(Activator.BUNDLE_MARKER, "Failed to add local repository: " + e, (Throwable)e);
        }
    }

    private static File getRepositoryRoot() throws FileNotFoundException {
        File repositoryRoot;
        String repositoryPath = System.getProperty(ORG_BUNDLEBEE_REPOSITORY_ROOT, DEFAULT_REPOSITORY_ROOT).trim();
        if (repositoryPath != null && repositoryPath.startsWith("~")) {
            repositoryPath = System.getProperty("user.home") + repositoryPath.substring(1);
        }
        if (!(repositoryRoot = new File(repositoryPath)).exists()) {
            throw new FileNotFoundException("Repository root " + repositoryRoot + " does not exist.");
        }
        if (!repositoryRoot.canRead()) {
            throw new FileNotFoundException("Repository root " + repositoryRoot + " is not readable.");
        }
        return repositoryRoot;
    }

    private void listAllAvailableResources(RepositoryAdmin repositoryAdmin) {
        org.osgi.service.obr.Repository[] repositories;
        for (org.osgi.service.obr.Repository repository : repositories = repositoryAdmin.listRepositories()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(Activator.BUNDLE_MARKER, "Repository at " + repository.getURL());
            }
            this.listAllAvailableResources(repository);
        }
    }

    private void listAllAvailableResources(org.osgi.service.obr.Repository repository) {
        Resource[] resources = repository.getResources();
        if (resources != null) {
            for (Resource resource : resources) {
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug(Activator.BUNDLE_MARKER, "Resource: " + resource.getPresentationName() + " - " + resource.getSymbolicName() + " - " + resource.getId());
            }
        }
    }

    private boolean hasBeenModified(URL url) {
        Long cachedLastModified = this.lastModifiedMap.get(url);
        Long realLastModified = this.getLastModified(url);
        if (!realLastModified.equals(cachedLastModified)) {
            if (realLastModified != 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("URL at " + url + " has been modified.");
                }
                this.lastModifiedMap.put(url, realLastModified);
            }
            return true;
        }
        return false;
    }

    private Long getLastModified(URL url) {
        try {
            URLConnection urlConnection = url.openConnection();
            urlConnection.setConnectTimeout(500);
            urlConnection.setReadTimeout(500);
            if (urlConnection instanceof HttpURLConnection) {
                ((HttpURLConnection)urlConnection).setRequestMethod("HEAD");
            }
            return urlConnection.getLastModified();
        }
        catch (IOException e) {
            LOG.error("Failed to get date of last modification for " + url, (Throwable)e);
            return 0L;
        }
    }

    private boolean isRepositoryAdded(RepositoryAdmin repositoryAdmin, URL url) {
        for (org.osgi.service.obr.Repository repository : repositoryAdmin.listRepositories()) {
            if (!url.equals(repository.getURL())) continue;
            return true;
        }
        return false;
    }
}

