/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.weaver.equinox;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.joran.spi.JoranException;
import java.io.File;
import java.io.IOException;
import java.net.URLConnection;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import javassist.ClassPool;
import org.bundlebee.registry.impl.RegistryImpl;
import org.bundlebee.weaver.equinox.Weaver;
import org.eclipse.osgi.baseadaptor.BaseAdaptor;
import org.eclipse.osgi.baseadaptor.BaseData;
import org.eclipse.osgi.baseadaptor.HookConfigurator;
import org.eclipse.osgi.baseadaptor.HookRegistry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.hooks.AdaptorHook;
import org.eclipse.osgi.baseadaptor.hooks.ClassLoadingHook;
import org.eclipse.osgi.baseadaptor.loader.BaseClassLoader;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.eclipse.osgi.baseadaptor.loader.ClasspathManager;
import org.eclipse.osgi.framework.adaptor.BundleProtectionDomain;
import org.eclipse.osgi.framework.adaptor.ClassLoaderDelegate;
import org.eclipse.osgi.framework.internal.core.BundleLoader;
import org.eclipse.osgi.framework.log.FrameworkLog;
import org.eclipse.osgi.util.ManifestElement;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleBeeClassLoadingHook
implements ClassLoadingHook,
HookConfigurator,
AdaptorHook {
    private static Logger LOG = LoggerFactory.getLogger(BundleBeeClassLoadingHook.class);
    private final ClassPool classPool;
    private final String dynamicImportPackages;
    private final Weaver mWeaver = new Weaver();

    public BundleBeeClassLoadingHook() {
        this.classPool = ClassPool.getDefault();
        this.dynamicImportPackages = this.computeDynamicImportPackages(this.classPool);
    }

    public byte[] processClass(String classname, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry bundleEntry, ClasspathManager classpathManager) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing class " + classname + "...");
        }
        ClassLoader cl = (ClassLoader)classpathManager.getBaseClassLoader();
        return this.mWeaver.weaveClass(classbytes, classpathEntry, cl);
    }

    public boolean addClassPathEntry(ArrayList arrayList, String s, ClasspathManager classpathManager, BaseData baseData, ProtectionDomain protectionDomain) {
        return false;
    }

    public String findLibrary(BaseData baseData, String s) {
        return null;
    }

    public ClassLoader getBundleClassLoaderParent() {
        return null;
    }

    public BaseClassLoader createClassLoader(ClassLoader classLoader, ClassLoaderDelegate classLoaderDelegate, BundleProtectionDomain bundleProtectionDomain, BaseData baseData, String[] strings) {
        BundleLoader bundleLoader = (BundleLoader)classLoaderDelegate;
        try {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Adding dynamic import packages: " + this.dynamicImportPackages);
            }
            bundleLoader.addDynamicImportPackage(ManifestElement.parseHeader((String)"DynamicImport-Package", (String)this.dynamicImportPackages));
        }
        catch (BundleException e) {
            LOG.error(e.toString(), e);
        }
        return null;
    }

    public void initializedClassLoader(BaseClassLoader baseClassLoader, BaseData baseData) {
    }

    public void addHooks(HookRegistry hookRegistry) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding " + this.getClass().getName() + " as hook to HookRegistry...");
        }
        BundleBeeClassLoadingHook hook = this;
        hookRegistry.addClassLoadingHook((ClassLoadingHook)hook);
        hookRegistry.addAdaptorHook((AdaptorHook)hook);
    }

    private String computeDynamicImportPackages(ClassPool classPool) {
        StringBuilder sb = new StringBuilder();
        Iterator packageIterator = classPool.getImportedPackages();
        while (packageIterator.hasNext()) {
            Object o = packageIterator.next();
            if ("java.lang".equals(o)) continue;
            sb.append(o).append(',');
        }
        if (sb.length() > 1) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    public void initialize(BaseAdaptor baseAdaptor) {
    }

    public void frameworkStart(BundleContext bundleContext) throws BundleException {
    }

    public void frameworkStop(BundleContext bundleContext) throws BundleException {
        if (LOG.isInfoEnabled()) {
            LOG.info("Stopping BundleBee Registry.");
        }
        RegistryImpl.getInstance().stop();
    }

    public void frameworkStopping(BundleContext bundleContext) {
    }

    public void addProperties(Properties properties) {
    }

    public URLConnection mapLocationToURLConnection(String s) throws IOException {
        return null;
    }

    public void handleRuntimeError(Throwable throwable) {
    }

    public boolean matchDNChain(String s, String[] strings) {
        return false;
    }

    public FrameworkLog createFrameworkLog() {
        return null;
    }

    static {
        new File("logs").mkdirs();
        LoggerContext lc = (LoggerContext)LoggerFactory.getILoggerFactory();
        try {
            lc.shutdownAndReset();
            ContextInitializer.autoConfig(lc, Logger.class.getClassLoader());
        }
        catch (JoranException e) {
            LOG.error("Failure while configuring logback : " + e.toString(), e);
        }
    }
}

