/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.repository.impl;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bundlebee.repository.impl.Activator;
import org.osgi.service.http.HttpContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleFileHttpContext
implements HttpContext {
    private static final Logger LOG = LoggerFactory.getLogger(SimpleFileHttpContext.class);
    private HttpContext httpContext;
    private File root;

    SimpleFileHttpContext(HttpContext httpContext, File root) throws IOException {
        this.httpContext = httpContext;
        this.root = root.getCanonicalFile();
    }

    public boolean handleSecurity(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        return this.httpContext.handleSecurity(httpServletRequest, httpServletResponse);
    }

    public URL getResource(String name) {
        URL url = null;
        try {
            File file;
            if (LOG.isDebugEnabled()) {
                LOG.debug(Activator.BUNDLE_MARKER, "Requested Resource: " + name);
            }
            if ((file = new File(name).getCanonicalFile()).toString().startsWith(this.root.toString())) {
                url = file.toURL();
            } else if (LOG.isDebugEnabled()) {
                LOG.debug(Activator.BUNDLE_MARKER, "Houston, we have a problem: Illegal request: " + name);
            }
        }
        catch (IOException e) {
            LOG.error(Activator.BUNDLE_MARKER, e.toString(), (Throwable)e);
        }
        return url;
    }

    public String getMimeType(String name) {
        if (name.endsWith(".jar")) {
            return "application/java-archive";
        }
        return this.httpContext.getMimeType(name);
    }
}

