/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.registry.impl;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import org.bundlebee.registry.Registry;
import org.bundlebee.registry.directory.Grid;
import org.bundlebee.registry.directory.RegistryDirectory;
import org.bundlebee.registry.net.MultiCastMessage;
import org.bundlebee.registry.net.Network;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class RegistryImpl
implements Registry {
    private static Logger LOG = LoggerFactory.getLogger(RegistryImpl.class);
    public static final String ID = "org.bundlebee.registry";
    public static final Marker BUNDLE_MARKER = RegistryImpl.createBundleMarker();
    private static final String ORG_BUNDLEBEE_REGISTRY_REFRESHPERIOD = "org.bundlebee.registry.refreshperiod";
    private static final int DEFAULT_REFRESH_PERIOD = 60000;
    private Network network;
    private final Thread shutdownHook = new Thread("BundleBeeRegistryShutdown"){

        public void run() {
            RegistryImpl.this.stop();
        }
    };
    private static Registry instance = new RegistryImpl();
    private RegistryDirectory registryDirectory;
    private final long nodeId = Math.abs(UUID.randomUUID().getLeastSignificantBits());
    private Timer periodicRefresh;
    private long refreshPeriod = RegistryImpl.initRefreshPeriod();

    private static Marker createBundleMarker() {
        Marker bundleMarker = MarkerFactory.getMarker(ID);
        bundleMarker.add(MarkerFactory.getMarker("IS_MARKER"));
        return bundleMarker;
    }

    private RegistryImpl() {
        if (LOG.isInfoEnabled()) {
            LOG.info(BUNDLE_MARKER, "NODE_ID = " + this.nodeId);
        }
        try {
            this.registryDirectory = new RegistryDirectory();
            this.network = new Network(this.registryDirectory, this.registryDirectory, this.nodeId);
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
            this.start();
        }
        catch (Exception e) {
            LOG.error(BUNDLE_MARKER, "Failed to start bundlebee registry: " + e.toString(), e);
            throw new RuntimeException("Failed to start bundlebee registry", e);
        }
    }

    public MultiCastMessage[] getList() {
        return this.registryDirectory.getList();
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public static Registry getInstance() {
        return instance;
    }

    public void start() {
        this.periodicRefresh = new Timer("PeriodicRegistryRefresh");
        this.periodicRefresh.schedule(new TimerTask(){

            public void run() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(BUNDLE_MARKER, "Starting periodic refresh...");
                }
                RegistryImpl.this.refresh();
            }
        }, this.refreshPeriod, this.refreshPeriod);
    }

    private static long initRefreshPeriod() {
        String s = System.getProperty(ORG_BUNDLEBEE_REGISTRY_REFRESHPERIOD, "60000");
        long refreshPeriod = 60000L;
        try {
            refreshPeriod = Long.parseLong(s);
        }
        catch (NumberFormatException e) {
            LOG.error(e.toString(), e);
        }
        return refreshPeriod;
    }

    public void stop() {
        this.periodicRefresh.cancel();
        this.unregisterNode();
        this.network.stop();
        if (LOG.isDebugEnabled() && LOG.isDebugEnabled()) {
            LOG.debug(BUNDLE_MARKER, "...done");
        }
        if (Thread.currentThread() != this.shutdownHook) {
            Runtime.getRuntime().removeShutdownHook(this.shutdownHook);
        }
    }

    public void registerManager(URL url) {
        this.registryDirectory.setURLMessage(MultiCastMessage.Type.MANAGER, url, MultiCastMessage.Operation.ADD);
    }

    public void unregisterManager(URL url) {
        this.registryDirectory.setURLMessage(MultiCastMessage.Type.MANAGER, url, MultiCastMessage.Operation.REMOVE);
    }

    public void registerRepository(URL url) {
        this.registryDirectory.setURLMessage(MultiCastMessage.Type.REPOSITORY, url, MultiCastMessage.Operation.ADD);
    }

    public void unregisterRepository(URL url) {
        this.registryDirectory.setURLMessage(MultiCastMessage.Type.REPOSITORY, url, MultiCastMessage.Operation.REMOVE);
    }

    public void registerBundle(String bundleSymbolicNameVersion, int bundleState) {
        if (LOG.isDebugEnabled() && LOG.isDebugEnabled()) {
            LOG.debug(BUNDLE_MARKER, "registerBundle(" + bundleSymbolicNameVersion + ", " + bundleState + ")");
        }
        this.registryDirectory.setBundleMessage(bundleSymbolicNameVersion, bundleState, MultiCastMessage.Operation.ADD);
    }

    public void unregisterBundle(String bundleSymbolicNameVersion) {
        if (LOG.isDebugEnabled() && LOG.isDebugEnabled()) {
            LOG.debug(BUNDLE_MARKER, "unregisterBundle(" + bundleSymbolicNameVersion + ")");
        }
        this.registryDirectory.setBundleMessage(bundleSymbolicNameVersion, MultiCastMessage.Operation.REMOVE);
    }

    public void registerMemory(long freeMemory, long maxMemory) {
        if (LOG.isDebugEnabled() && LOG.isDebugEnabled()) {
            LOG.debug(BUNDLE_MARKER, "registerMemory(" + freeMemory + ", " + maxMemory + ")");
        }
        this.registryDirectory.setMemoryMessage(freeMemory, maxMemory, MultiCastMessage.Operation.ADD);
    }

    public Grid getGrid() {
        return this.registryDirectory.getGrid();
    }

    public void refresh() {
        this.registryDirectory.setHiMessage();
    }

    public void unregisterNode() {
        if (LOG.isDebugEnabled() && LOG.isDebugEnabled()) {
            LOG.debug(BUNDLE_MARKER, "unregisterNode()");
        }
        this.registryDirectory.setNodeMessage(MultiCastMessage.Operation.REMOVE);
    }

    public void test() {
        try {
            URL url = new URL("http://" + InetAddress.getLocalHost().getHostAddress() + ":8080");
            this.registerRepository(url);
            this.registerManager(url);
            Thread.sleep(10000L);
            this.unregisterManager(url);
            this.unregisterRepository(url);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }
}

