/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.examples.fractal;

import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.Timer;
import org.bundlebee.examples.fractal.BufferedImagePanel;
import org.bundlebee.examples.fractal.GlowingBorderEffect;

public class EffectManager {
    private final List<GlowingBorderEffect> mEffects = Collections.synchronizedList(new ArrayList());

    public EffectManager(final BufferedImagePanel target) {
        Timer t = new Timer(100, new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                List list = EffectManager.this.mEffects;
                synchronized (list) {
                    Iterator it = EffectManager.this.mEffects.iterator();
                    while (it.hasNext()) {
                        GlowingBorderEffect eff = (GlowingBorderEffect)it.next();
                        if (eff.isFinished()) {
                            it.remove();
                        }
                        target.repaint(eff.getRectangle());
                    }
                }
            }
        });
        t.setRepeats(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void display(Graphics2D g2) {
        List<GlowingBorderEffect> list = this.mEffects;
        synchronized (list) {
            for (GlowingBorderEffect e : this.mEffects) {
                e.display(g2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addEffect(GlowingBorderEffect e) {
        List<GlowingBorderEffect> list = this.mEffects;
        synchronized (list) {
            this.mEffects.add(e);
        }
    }
}

