/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.remoteservicecall;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleLifecycleClient {
    private static Logger LOG = LoggerFactory.getLogger(BundleLifecycleClient.class);
    public static final String ORG_BUNDLEBEE_REMOTESERVICECALL_CONNECTTIMEOUT = "org.bundlebee.remoteservicecall.bundlelifecycleclient.connecttimeout";
    public static final String ORG_BUNDLEBEE_REMOTESERVICECALL_READTIMEOUT = "org.bundlebee.remoteservicecall.bundlelifecycleclient.readtimeout";
    private static final int DEFAULT_READ_TIMEOUT = 60000;
    private static final int DEFAULT_CONNECT_TIMEOUT = 500;
    private static final int READ_TIMEOUT;
    private static final int CONNECT_TIMEOUT;
    private static final String HTTP_POST = "POST";
    private int connectTimeout = 500;
    private int readTimeout = 60000;

    public BundleLifecycleClient() {
        this.setConnectTimeout(CONNECT_TIMEOUT);
        this.setReadTimeout(READ_TIMEOUT);
    }

    public List<URL> startBundle(Collection<URL> managerURLs, String bundleSymbolicNameVersion) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("startBundle(" + bundleSymbolicNameVersion + ") on " + managerURLs);
        }
        ArrayList<URL> managersWithStartedBundle = new ArrayList<URL>();
        for (URL url : managerURLs) {
            try {
                int responseCodeStart = this.post(url, Method.START, bundleSymbolicNameVersion);
                if (responseCodeStart != 200) continue;
                managersWithStartedBundle.add(url);
                break;
            }
            catch (IOException e) {
                LOG.error(e.toString(), (Throwable)e);
            }
        }
        return managersWithStartedBundle;
    }

    public List<URL> installAndStartBundle(Collection<URL> managerURLs, String bundleSymbolicNameVersion) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("installAndStartBundle(" + bundleSymbolicNameVersion + ") on " + managerURLs);
        }
        ArrayList<URL> managersWithDeployedBundle = new ArrayList<URL>();
        for (URL url : managerURLs) {
            try {
                int responseCodeStart;
                int responseCodeInstall = this.post(url, Method.INSTALL, bundleSymbolicNameVersion);
                if (responseCodeInstall != 200 || (responseCodeStart = this.post(url, Method.START, bundleSymbolicNameVersion)) != 200) continue;
                managersWithDeployedBundle.add(url);
                break;
            }
            catch (IOException e) {
                LOG.error(e.toString(), (Throwable)e);
            }
        }
        return managersWithDeployedBundle;
    }

    public static URL toDirectoryURL(URL url) throws MalformedURLException {
        if (!url.toString().endsWith("/")) {
            return new URL(url.toString() + "/");
        }
        return url;
    }

    public int post(URL managerURL, Method method, String bundleSymbolicNameVersion) throws IOException {
        return this.openConnection(managerURL, method, bundleSymbolicNameVersion).getResponseCode();
    }

    public HttpURLConnection openConnection(URL managerURL, Method method, String bundleSymbolicNameVersion) throws IOException {
        URL url = new URL(BundleLifecycleClient.toDirectoryURL(managerURL), method.getMethod() + "/" + bundleSymbolicNameVersion);
        HttpURLConnection urlConnection = (HttpURLConnection)url.openConnection();
        urlConnection.setRequestMethod(HTTP_POST);
        urlConnection.setReadTimeout(this.readTimeout);
        urlConnection.setConnectTimeout(this.connectTimeout);
        return urlConnection;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        if (connectTimeout == 0) {
            throw new IllegalArgumentException("Infinite connect timeouts are not permitted in this context.");
        }
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("Negative connect timeouts are not permitted in this context.");
        }
        this.connectTimeout = connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        if (readTimeout == 0) {
            throw new IllegalArgumentException("Infinite read timeouts are not permitted in this context.");
        }
        if (readTimeout < 0) {
            throw new IllegalArgumentException("Negative read timeouts are not permitted in this context.");
        }
        this.readTimeout = readTimeout;
    }

    static {
        int defConnectTimeout = 500;
        try {
            String property = System.getProperty(ORG_BUNDLEBEE_REMOTESERVICECALL_CONNECTTIMEOUT, Integer.toString(500));
            defConnectTimeout = Integer.parseInt(property);
            LOG.info("Default connect timeout set to " + defConnectTimeout + " ms.");
        }
        catch (NumberFormatException e) {
            LOG.error("Failed to parse connect timeout: " + e.toString(), (Throwable)e);
        }
        CONNECT_TIMEOUT = defConnectTimeout;
        int defReadTimeout = 60000;
        try {
            String property = System.getProperty(ORG_BUNDLEBEE_REMOTESERVICECALL_READTIMEOUT, Integer.toString(60000));
            defReadTimeout = Integer.parseInt(property);
            LOG.info("Default read timeout set to " + defReadTimeout + " ms.");
        }
        catch (NumberFormatException e) {
            LOG.error("Failed to parse read timeout: " + e.toString(), (Throwable)e);
        }
        READ_TIMEOUT = defReadTimeout;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Method {
        START("start"),
        STOP("stop"),
        INSTALL("install"),
        UNINSTALL("uninstall");

        private String method;

        private Method(String method) {
            this.method = method;
        }

        public String getMethod() {
            return this.method;
        }
    }
}

