/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.obr.resource;

import org.osgi.impl.bundle.obr.resource.FilterImpl;
import org.osgi.impl.bundle.obr.resource.Tag;
import org.osgi.service.obr.Capability;
import org.osgi.service.obr.Requirement;
import org.xmlpull.v1.XmlPullParser;

public class RequirementImpl
implements Requirement {
    int id;
    String name;
    String filter = "()";
    FilterImpl _filter;
    String comment;
    boolean optional;
    boolean multiple;
    boolean extend;

    public RequirementImpl(String name) {
        this.name = name;
    }

    public RequirementImpl(XmlPullParser parser) throws Exception {
        parser.require(2, null, null);
        this.name = parser.getAttributeValue(null, "name");
        this.filter = parser.getAttributeValue(null, "filter");
        String opt = parser.getAttributeValue(null, "optional");
        String mul = parser.getAttributeValue(null, "multiple");
        String ext = parser.getAttributeValue(null, "extend");
        this.optional = "true".equalsIgnoreCase(opt);
        this.multiple = "true".equalsIgnoreCase(mul);
        this.extend = "true".equalsIgnoreCase(ext);
        StringBuffer sb = new StringBuffer();
        while (parser.next() == 4) {
            sb.append(parser.getText());
        }
        if (sb.length() > 0) {
            this.setComment(sb.toString().trim());
        }
        parser.require(3, null, null);
    }

    public void setFilter(String filter) {
        this.filter = filter;
        this._filter = null;
    }

    public String getFilter() {
        return this.filter;
    }

    public Tag toXML(String name) {
        Tag tag = RequirementImpl.toXML(this);
        tag.rename(name);
        return tag;
    }

    public String getName() {
        return this.name;
    }

    public boolean isSatisfied(Capability capability) {
        if (this._filter == null) {
            this._filter = new FilterImpl(this.filter);
        }
        boolean result = this._filter.match(capability.getProperties());
        return result;
    }

    public String toString() {
        return this.name + " " + this.filter;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public static Tag toXML(Requirement requirement) {
        Tag req = new Tag("require");
        req.addAttribute("name", requirement.getName());
        req.addAttribute("filter", requirement.getFilter());
        req.addAttribute("optional", requirement.isOptional() + "");
        req.addAttribute("multiple", requirement.isMultiple() + "");
        req.addAttribute("extend", requirement.isExtend() + "");
        if (requirement.getComment() != null) {
            req.addContent(requirement.getComment());
        }
        return req;
    }

    public boolean isMultiple() {
        return this.multiple;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean b) {
        this.optional = b;
    }

    public void setMultiple(boolean b) {
        this.multiple = b;
    }

    public boolean equals(Object o) {
        if (!(o instanceof Requirement)) {
            return false;
        }
        Requirement r2 = (Requirement)o;
        return this.filter.equals(r2.getFilter()) && this.name.equals(r2.getName());
    }

    public int hashCode() {
        return this.filter.hashCode() ^ this.name.hashCode();
    }

    public boolean isExtend() {
        return this.extend;
    }

    public void setExtend(boolean extend) {
        this.extend = extend;
    }
}

