/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.carrier;

import org.bundlebee.carrier.DeploymentException;
import org.osgi.service.obr.Requirement;
import org.osgi.service.obr.Resource;

public class UnsatisfiedRequirementsException
extends DeploymentException {
    static final long serialVersionUID = 42L;
    private static final String LINE_SEP = System.getProperty("line.separator");
    private Resource resource;
    private Requirement[] requirements;

    public UnsatisfiedRequirementsException(Resource resource, Requirement[] requirements) {
        super(UnsatisfiedRequirementsException.createMessage(resource, requirements));
        this.requirements = requirements;
        this.resource = resource;
    }

    public Resource getResource() {
        return this.resource;
    }

    public Requirement[] getRequirements() {
        return this.requirements;
    }

    private static String createMessage(Resource resource, Requirement[] requirements) {
        StringBuilder sb = new StringBuilder();
        sb.append("Failed to satisfy requirements for " + resource.getId() + ":");
        for (Requirement requirement : requirements) {
            sb.append(LINE_SEP).append('\t').append(requirement.getFilter()).append(", ").append(requirement.getName());
        }
        return sb.toString();
    }
}

