/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.weaver;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Random;
import org.bundlebee.registry.Registry;
import org.bundlebee.remoteservicecall.BundleLifecycleClient;
import org.bundlebee.weaver.ServiceCallDispatchStrategy;
import org.bundlebee.weaver.ServiceCallStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomDispatchStrategy
implements ServiceCallDispatchStrategy {
    private static Logger LOG = LoggerFactory.getLogger(RandomDispatchStrategy.class);
    private Registry registry;
    private Random random = new Random();
    private BundleLifecycleClient bundleLifecycleClient = new BundleLifecycleClient();

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setServiceCallStats(ServiceCallStats serviceCallStats) {
    }

    public URI getManagerURI(String bundleSymbolicNameVersion, Object service, String methodname, Class[] parameterTypes) {
        ArrayList<URL> managerURLs = new ArrayList<URL>(this.registry.getGrid().getManagers());
        if (managerURLs.isEmpty()) {
            return null;
        }
        URL chosenManagerURL = (URL)managerURLs.get(this.random.nextInt(managerURLs.size()));
        ArrayList<URL> chosenManagerURLs = new ArrayList<URL>();
        chosenManagerURLs.add(chosenManagerURL);
        if (this.registry.getGrid().getManagers(bundleSymbolicNameVersion, 2).contains(chosenManagerURL) || this.registry.getGrid().getManagers(bundleSymbolicNameVersion, 4).contains(chosenManagerURL)) {
            chosenManagerURLs.retainAll(this.bundleLifecycleClient.startBundle(chosenManagerURLs, bundleSymbolicNameVersion));
        } else if (this.registry.getGrid().getManagers(bundleSymbolicNameVersion, 1).contains(chosenManagerURL)) {
            chosenManagerURLs.retainAll(this.bundleLifecycleClient.installAndStartBundle(chosenManagerURLs, bundleSymbolicNameVersion));
        } else {
            chosenManagerURLs.retainAll(this.bundleLifecycleClient.installAndStartBundle(chosenManagerURLs, bundleSymbolicNameVersion));
        }
        if (chosenManagerURLs.isEmpty()) {
            return null;
        }
        if (!chosenManagerURLs.isEmpty()) {
            try {
                return ((URL)chosenManagerURLs.get(0)).toURI();
            }
            catch (URISyntaxException e) {
                LOG.error(e.toString(), e);
            }
        }
        return null;
    }
}

