/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.examples.fractal.mandelbrot;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.awt.image.WritableRaster;
import java.util.Collection;
import org.bundlebee.examples.fractal.AsynchronousContentRequest;
import org.bundlebee.examples.fractal.ContentProvider;
import org.bundlebee.examples.fractal.GlowingRoundRect;
import org.bundlebee.examples.fractal.HalfsizingChunkifier;
import org.bundlebee.examples.fractal.mandelbrot.Complex;
import org.bundlebee.examples.fractal.mandelbrot.ComplexArea;
import org.bundlebee.examples.fractal.mandelbrot.MandelbrotAlgorithm;

public class MandelbrotContentProvider
implements ContentProvider {
    public static final int DEFAULT_MAXDEPTH = 64;
    public static final int DEFAULT_CHUNKS = 16;
    private final MandelbrotAlgorithm mMandel = new MandelbrotAlgorithm();
    private Complex mTopLeft = new Complex(-2.0, -2.0);
    private Complex mSize = new Complex(4.0, 4.0);
    private int mMaxDepth = 64;
    private int mChunks = 16;
    private HalfsizingChunkifier mChunker = new HalfsizingChunkifier(16);

    public void setTopLeft(Complex topleft) {
        this.mTopLeft = topleft;
    }

    public void setSize(Complex size) {
        this.mSize = size;
    }

    public void setArea(ComplexArea area) {
        this.mTopLeft = area.topleft();
        this.mSize = area.size();
    }

    public void setMaxDepth(int maxdepth) {
        this.mMaxDepth = maxdepth;
    }

    public void setChunks(int chunks) {
        this.mChunks = chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void request(final AsynchronousContentRequest r) {
        BufferedImage img = r.getBufferedImage();
        int w = img.getWidth();
        int h = img.getHeight();
        double dx = this.dx(w, h);
        final Complex dz = new Complex(dx, dx);
        this.mChunker.setChunks(this.mChunks);
        BufferedImage bufferedImage = img;
        synchronized (bufferedImage) {
            Collection<Rectangle> chunks = this.mChunker.chunkify(new Rectangle(0, 0, w, h));
            for (final Rectangle rect : chunks) {
                if (r.isCancelled()) {
                    System.out.println("cancelled mandelbrot before chunk " + rect);
                    return;
                }
                Graphics2D g2d = img.createGraphics();
                g2d.setColor(new Color(128, 128, 128, 128));
                g2d.fillRect(rect.x, rect.y, rect.width, rect.height);
                GlowingRoundRect.paint(g2d, rect, 4, Color.GRAY, 4, 1.0f);
                g2d.dispose();
                r.updated(rect, true);
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        Complex z0 = new Complex(MandelbrotContentProvider.this.mTopLeft.re() + dz.re() * (double)rect.x, MandelbrotContentProvider.this.mTopLeft.im() + dz.im() * (double)rect.y);
                        MandelbrotContentProvider.this.compute(r, z0, dz, rect, MandelbrotContentProvider.this.mMaxDepth);
                        r.progress(1.0f / (float)MandelbrotContentProvider.this.mChunks);
                    }
                });
                t.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void compute(AsynchronousContentRequest r, Complex z0, Complex dz, Rectangle rect, int maxdepth) {
        int[][] res = this.mMandel.computeArea(z0, dz, rect.width, rect.height, maxdepth);
        BufferedImage img = r.getBufferedImage();
        if (!r.isCancelled()) {
            BufferedImage bufferedImage = img;
            synchronized (bufferedImage) {
                WritableRaster raster = img.getRaster();
                int[] color = new int[4];
                for (int i = 0; i < rect.width; ++i) {
                    for (int j = 0; j < rect.height; ++j) {
                        this.fillColor(res[i][j], maxdepth, color);
                        raster.setPixel(rect.x + i, rect.y + j, color);
                    }
                }
                if (r.isCancelled()) {
                    System.out.println("cancelled mandelbrot when leaving chunk " + rect);
                    return;
                }
            }
        }
        r.updated(rect, false);
    }

    private void fillColor(int depth, int maxdepth, int[] color) {
        color[3] = 255;
        if (depth == maxdepth) {
            color[0] = 0;
            color[1] = 0;
            color[2] = 0;
            return;
        }
        color[0] = (depth *= 1000) & 0xFF;
        color[1] = depth >> 8 & 0xFF;
        color[2] = depth >> 16 & 0xFF;
    }

    private double dx(int width, int height) {
        double w = width;
        double h = height;
        double ratiotarget = w / h;
        double ratiosource = this.mSize.re() / this.mSize.im();
        double dx = ratiotarget > ratiosource ? this.mSize.im() / h : this.mSize.re() / w;
        return dx;
    }

    public void zoomTo(Dimension currentsize, Rectangle zoom) {
        double dx = this.dx(currentsize.width, currentsize.height);
        this.mTopLeft = new Complex(this.mTopLeft.re() + (double)zoom.x * dx, this.mTopLeft.im() + (double)zoom.y * dx);
        this.mSize = new Complex((double)zoom.width * dx, (double)zoom.height * dx);
    }

    public ComplexArea getDisplayedArea(Dimension screensize) {
        double dx = this.dx(screensize.width, screensize.height);
        Complex size = new Complex((double)screensize.width * dx, (double)screensize.height * dx);
        return new ComplexArea(this.mTopLeft, size);
    }
}

