/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.examples.fractal;

import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSpinner;
import javax.swing.JToggleButton;
import javax.swing.Timer;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.bundlebee.examples.fractal.AsynchronousContentRequest;
import org.bundlebee.examples.fractal.BufferedImagePanel;
import org.bundlebee.examples.fractal.BufferedImageProvider;
import org.bundlebee.examples.fractal.FractalAboutBox;
import org.bundlebee.examples.fractal.FractalApp;
import org.bundlebee.examples.fractal.SnapshotPanel;
import org.bundlebee.examples.fractal.SnapshotsPanel;
import org.bundlebee.examples.fractal.mandelbrot.ComplexArea;
import org.bundlebee.examples.fractal.mandelbrot.MandelbrotContentProvider;
import org.jdesktop.application.Action;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.TaskMonitor;
import org.jdesktop.layout.GroupLayout;

public class FractalView
extends FrameView {
    private int mAutoAnimateHistory = -1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JToggleButton mAutoAnimateToggleButton;
    private JPanel mBufferImagePanelContainer;
    private JPanel mChunksPanel;
    private JSpinner mChunksSpinner;
    private JPanel mControlUI;
    private JPanel mMaxDepthPanel;
    private JSpinner mMaxDepthSpinner;
    private SnapshotsPanel mSnapshotsPanel;
    private JScrollPane mSnapshotsScrollPane;
    private JButton mZoomBackButton;
    private JPanel mainPanel;
    private JMenuBar menuBar;
    private JLabel minnoQLabel;
    private JProgressBar progressBar;
    private JLabel statusAnimationLabel;
    private JLabel statusMessageLabel;
    private JPanel statusPanel;
    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;
    private JDialog aboutBox;
    MandelbrotContentProvider mMandel = new MandelbrotContentProvider();
    BufferedImagePanel mFractalContentPanel;
    List<ComplexArea> mZoomHistory = new ArrayList<ComplexArea>();
    private final AsynchronousContentRequest.Observer mRequestObserver = new AsynchronousContentRequest.Observer(){

        public void started() {
            FractalView.this.progressBar.setEnabled(true);
        }

        public void progressed(float p) {
            FractalView.this.progressBar.setMaximum(100);
            FractalView.this.progressBar.setMinimum(0);
            FractalView.this.progressBar.setValue((int)(p * 100.0f));
        }

        public void finished() {
            FractalView.this.progressBar.setEnabled(false);
            if (-1 != FractalView.this.mAutoAnimateHistory && FractalView.this.mZoomHistory.size() > 0) {
                if (FractalView.this.mAutoAnimateHistory > FractalView.this.mZoomHistory.size() - 1) {
                    FractalView.this.mAutoAnimateHistory = 0;
                }
                ComplexArea next = FractalView.this.mZoomHistory.get(FractalView.this.mAutoAnimateHistory);
                FractalView.this.mAutoAnimateHistory++;
                FractalView.this.mMandel.setArea(next);
                FractalView.this.mFractalContentPanel.updateContent();
            }
        }
    };

    public FractalView(SingleFrameApplication app) {
        super(app);
        this.initComponents();
        ResourceMap resourceMap = this.getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        this.messageTimer = new Timer(messageTimeout, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FractalView.this.statusMessageLabel.setText("");
            }
        });
        this.messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < this.busyIcons.length; ++i) {
            this.busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        this.busyIconTimer = new Timer(busyAnimationRate, new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FractalView.this.busyIconIndex = (FractalView.this.busyIconIndex + 1) % FractalView.this.busyIcons.length;
                FractalView.this.statusAnimationLabel.setIcon(FractalView.this.busyIcons[FractalView.this.busyIconIndex]);
            }
        });
        this.idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        this.statusAnimationLabel.setIcon(this.idleIcon);
        this.progressBar.setVisible(false);
        TaskMonitor taskMonitor = new TaskMonitor(this.getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!FractalView.this.busyIconTimer.isRunning()) {
                        FractalView.this.statusAnimationLabel.setIcon(FractalView.this.busyIcons[0]);
                        FractalView.this.busyIconIndex = 0;
                        FractalView.this.busyIconTimer.start();
                    }
                    FractalView.this.progressBar.setVisible(true);
                    FractalView.this.progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    FractalView.this.busyIconTimer.stop();
                    FractalView.this.statusAnimationLabel.setIcon(FractalView.this.idleIcon);
                    FractalView.this.progressBar.setVisible(false);
                    FractalView.this.progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)evt.getNewValue();
                    FractalView.this.statusMessageLabel.setText(text == null ? "" : text);
                    FractalView.this.messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)evt.getNewValue();
                    FractalView.this.progressBar.setVisible(true);
                    FractalView.this.progressBar.setIndeterminate(false);
                    FractalView.this.progressBar.setValue(value);
                }
            }
        });
        this.setupFractal();
    }

    @Action
    public void showAboutBox() {
        if (this.aboutBox == null) {
            JFrame mainFrame = FractalApp.getApplication().getMainFrame();
            this.aboutBox = new FractalAboutBox(mainFrame);
            this.aboutBox.setLocationRelativeTo(mainFrame);
        }
        FractalApp.getApplication().show(this.aboutBox);
    }

    private void initComponents() {
        this.mainPanel = new JPanel();
        this.mBufferImagePanelContainer = new JPanel();
        this.mControlUI = new JPanel();
        this.mMaxDepthPanel = new JPanel();
        this.mMaxDepthSpinner = new JSpinner();
        this.jLabel1 = new JLabel();
        this.mChunksPanel = new JPanel();
        this.jLabel2 = new JLabel();
        this.mChunksSpinner = new JSpinner();
        this.mZoomBackButton = new JButton();
        this.mSnapshotsScrollPane = new JScrollPane();
        this.mSnapshotsPanel = new SnapshotsPanel();
        this.mAutoAnimateToggleButton = new JToggleButton();
        this.menuBar = new JMenuBar();
        JMenu fileMenu = new JMenu();
        JMenuItem exitMenuItem = new JMenuItem();
        JMenu helpMenu = new JMenu();
        JMenuItem aboutMenuItem = new JMenuItem();
        this.statusPanel = new JPanel();
        JSeparator statusPanelSeparator = new JSeparator();
        this.statusMessageLabel = new JLabel();
        this.statusAnimationLabel = new JLabel();
        this.progressBar = new JProgressBar();
        this.minnoQLabel = new JLabel();
        this.mainPanel.setName("mainPanel");
        this.mBufferImagePanelContainer.setName("mBufferImagePanelContainer");
        GroupLayout mBufferImagePanelContainerLayout = new GroupLayout(this.mBufferImagePanelContainer);
        this.mBufferImagePanelContainer.setLayout(mBufferImagePanelContainerLayout);
        mBufferImagePanelContainerLayout.setHorizontalGroup(mBufferImagePanelContainerLayout.createParallelGroup(1).add(0, 596, Short.MAX_VALUE));
        mBufferImagePanelContainerLayout.setVerticalGroup(mBufferImagePanelContainerLayout.createParallelGroup(1).add(0, 230, Short.MAX_VALUE));
        this.mControlUI.setName("mControlUI");
        this.mMaxDepthPanel.setName("mMaxDepthPanel");
        this.mMaxDepthSpinner.setName("mMaxDepthSpinner");
        this.mMaxDepthSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                FractalView.this.mMaxDepthSpinnerStateChanged(evt);
            }
        });
        this.jLabel1.setDisplayedMnemonic('d');
        this.jLabel1.setLabelFor(this.mMaxDepthSpinner);
        ResourceMap resourceMap = Application.getInstance(FractalApp.class).getContext().getResourceMap(FractalView.class);
        this.jLabel1.setText(resourceMap.getString("jLabel1.text", new Object[0]));
        this.jLabel1.setName("jLabel1");
        GroupLayout mMaxDepthPanelLayout = new GroupLayout(this.mMaxDepthPanel);
        this.mMaxDepthPanel.setLayout(mMaxDepthPanelLayout);
        mMaxDepthPanelLayout.setHorizontalGroup(mMaxDepthPanelLayout.createParallelGroup(1).add(2, mMaxDepthPanelLayout.createSequentialGroup().add(this.jLabel1).addPreferredGap(0, -1, Short.MAX_VALUE).add(this.mMaxDepthSpinner, -2, 66, -2)));
        mMaxDepthPanelLayout.setVerticalGroup(mMaxDepthPanelLayout.createParallelGroup(1).add(this.mMaxDepthSpinner, -1, 28, Short.MAX_VALUE).add(this.jLabel1, -1, 28, Short.MAX_VALUE));
        this.mChunksPanel.setName("mChunksPanel");
        this.jLabel2.setDisplayedMnemonic('c');
        this.jLabel2.setLabelFor(this.mChunksSpinner);
        this.jLabel2.setText(resourceMap.getString("jLabel2.text", new Object[0]));
        this.jLabel2.setName("jLabel2");
        this.mChunksSpinner.setName("mChunksSpinner");
        this.mChunksSpinner.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                FractalView.this.mChunksSpinnerStateChanged(evt);
            }
        });
        GroupLayout mChunksPanelLayout = new GroupLayout(this.mChunksPanel);
        this.mChunksPanel.setLayout(mChunksPanelLayout);
        mChunksPanelLayout.setHorizontalGroup(mChunksPanelLayout.createParallelGroup(1).add(mChunksPanelLayout.createSequentialGroup().add(this.jLabel2).addPreferredGap(1).add(this.mChunksSpinner, -1, 70, Short.MAX_VALUE)));
        mChunksPanelLayout.setVerticalGroup(mChunksPanelLayout.createParallelGroup(1).add(this.jLabel2, -1, 25, Short.MAX_VALUE).add(this.mChunksSpinner, -1, 25, Short.MAX_VALUE));
        this.mZoomBackButton.setMnemonic('o');
        this.mZoomBackButton.setText(resourceMap.getString("mZoomBackButton.text", new Object[0]));
        this.mZoomBackButton.setName("mZoomBackButton");
        this.mZoomBackButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FractalView.this.mZoomBackButtonActionPerformed(evt);
            }
        });
        GroupLayout mControlUILayout = new GroupLayout(this.mControlUI);
        this.mControlUI.setLayout(mControlUILayout);
        mControlUILayout.setHorizontalGroup(mControlUILayout.createParallelGroup(1).add(2, mControlUILayout.createSequentialGroup().add(this.mChunksPanel, -2, -1, -2).addPreferredGap(0, 366, Short.MAX_VALUE).add(this.mZoomBackButton).addPreferredGap(0).add(this.mMaxDepthPanel, -2, -1, -2)));
        mControlUILayout.setVerticalGroup(mControlUILayout.createParallelGroup(1).add(mControlUILayout.createSequentialGroup().add(mControlUILayout.createParallelGroup(1).add(this.mChunksPanel, -2, -1, -2).add(this.mZoomBackButton).add(this.mMaxDepthPanel, -2, -1, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        this.mSnapshotsScrollPane.setHorizontalScrollBarPolicy(31);
        this.mSnapshotsScrollPane.setVerticalScrollBarPolicy(22);
        this.mSnapshotsScrollPane.setName("mSnapshotsScrollPane");
        this.mSnapshotsPanel.setName("mSnapshotsPanel");
        GroupLayout mSnapshotsPanelLayout = new GroupLayout(this.mSnapshotsPanel);
        this.mSnapshotsPanel.setLayout(mSnapshotsPanelLayout);
        mSnapshotsPanelLayout.setHorizontalGroup(mSnapshotsPanelLayout.createParallelGroup(1).add(0, 49, Short.MAX_VALUE));
        mSnapshotsPanelLayout.setVerticalGroup(mSnapshotsPanelLayout.createParallelGroup(1).add(0, 199, Short.MAX_VALUE));
        this.mSnapshotsScrollPane.setViewportView(this.mSnapshotsPanel);
        this.mAutoAnimateToggleButton.setText(resourceMap.getString("mAutoAnimateToggleButton.text", new Object[0]));
        this.mAutoAnimateToggleButton.setName("mAutoAnimateToggleButton");
        this.mAutoAnimateToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                FractalView.this.mAutoAnimateToggleButtonActionPerformed(evt);
            }
        });
        GroupLayout mainPanelLayout = new GroupLayout(this.mainPanel);
        this.mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(mainPanelLayout.createParallelGroup(1).add(mainPanelLayout.createSequentialGroup().addContainerGap().add(mainPanelLayout.createParallelGroup(1).add(this.mControlUI, -1, -1, Short.MAX_VALUE).add(mainPanelLayout.createSequentialGroup().add(this.mBufferImagePanelContainer, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add(mainPanelLayout.createParallelGroup(1).add(2, this.mSnapshotsScrollPane, -2, 68, -2).add(2, this.mAutoAnimateToggleButton, -2, 81, -2)))).addContainerGap()));
        mainPanelLayout.setVerticalGroup(mainPanelLayout.createParallelGroup(1).add(2, mainPanelLayout.createSequentialGroup().addContainerGap().add(mainPanelLayout.createParallelGroup(1).add(mainPanelLayout.createSequentialGroup().add(this.mSnapshotsScrollPane, -1, 201, Short.MAX_VALUE).addPreferredGap(0).add(this.mAutoAnimateToggleButton)).add(this.mBufferImagePanelContainer, -1, -1, Short.MAX_VALUE)).addPreferredGap(0).add(this.mControlUI, -2, -1, -2)));
        this.menuBar.setName("menuBar");
        fileMenu.setText(resourceMap.getString("fileMenu.text", new Object[0]));
        fileMenu.setName("fileMenu");
        ApplicationActionMap actionMap = Application.getInstance(FractalApp.class).getContext().getActionMap(FractalView.class, this);
        exitMenuItem.setAction(actionMap.get("quit"));
        exitMenuItem.setName("exitMenuItem");
        fileMenu.add(exitMenuItem);
        this.menuBar.add(fileMenu);
        helpMenu.setText(resourceMap.getString("helpMenu.text", new Object[0]));
        helpMenu.setName("helpMenu");
        aboutMenuItem.setAction(actionMap.get("showAboutBox"));
        aboutMenuItem.setName("aboutMenuItem");
        helpMenu.add(aboutMenuItem);
        this.menuBar.add(helpMenu);
        this.statusPanel.setName("statusPanel");
        statusPanelSeparator.setName("statusPanelSeparator");
        this.statusMessageLabel.setText(resourceMap.getString("statusMessageLabel.text", new Object[0]));
        this.statusMessageLabel.setName("statusMessageLabel");
        this.statusAnimationLabel.setHorizontalAlignment(2);
        this.statusAnimationLabel.setText(resourceMap.getString("statusAnimationLabel.text", new Object[0]));
        this.statusAnimationLabel.setName("statusAnimationLabel");
        this.progressBar.setEnabled(false);
        this.progressBar.setName("progressBar");
        this.progressBar.setStringPainted(true);
        this.minnoQLabel.setIcon(resourceMap.getIcon("minnoQLabel.icon"));
        this.minnoQLabel.setText(resourceMap.getString("minnoQLabel.text", new Object[0]));
        this.minnoQLabel.setName("minnoQLabel");
        GroupLayout statusPanelLayout = new GroupLayout(this.statusPanel);
        this.statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(statusPanelLayout.createParallelGroup(1).add(statusPanelSeparator, -1, 707, Short.MAX_VALUE).add(statusPanelLayout.createSequentialGroup().add(statusPanelLayout.createParallelGroup(1).add(statusPanelLayout.createSequentialGroup().add(62, 62, 62).add(this.statusMessageLabel)).add(this.minnoQLabel)).addPreferredGap(0, 447, Short.MAX_VALUE).add(this.progressBar, -2, -1, -2).addPreferredGap(0).add(this.statusAnimationLabel).addContainerGap()));
        statusPanelLayout.setVerticalGroup(statusPanelLayout.createParallelGroup(1).add(statusPanelLayout.createSequentialGroup().add(statusPanelSeparator, -2, 2, -2).addPreferredGap(0, -1, Short.MAX_VALUE).add(statusPanelLayout.createParallelGroup(2).add(statusPanelLayout.createSequentialGroup().add(statusPanelLayout.createParallelGroup(3).add(this.progressBar, -2, -1, -2).add(this.statusAnimationLabel).add(this.statusMessageLabel)).add(3, 3, 3)).add(this.minnoQLabel))));
        this.setComponent(this.mainPanel);
        this.setMenuBar(this.menuBar);
        this.setStatusBar(this.statusPanel);
    }

    private void mMaxDepthSpinnerStateChanged(ChangeEvent evt) {
        int spin = (Integer)this.mMaxDepthSpinner.getValue();
        this.mMandel.setMaxDepth(spin);
        this.mFractalContentPanel.updateContent();
    }

    private void mChunksSpinnerStateChanged(ChangeEvent evt) {
        this.mMandel.setChunks((Integer)this.mChunksSpinner.getValue());
        this.mFractalContentPanel.updateContent();
    }

    private void mZoomBackButtonActionPerformed(ActionEvent evt) {
        if (this.mAutoAnimateHistory == -1 && this.mZoomHistory.size() > 0) {
            ComplexArea last = this.mZoomHistory.get(this.mZoomHistory.size() - 1);
            this.mZoomHistory.remove(this.mZoomHistory.size() - 1);
            this.mMandel.setArea(last);
            this.mFractalContentPanel.updateContent();
        }
    }

    private void mAutoAnimateToggleButtonActionPerformed(ActionEvent evt) {
        if (this.mAutoAnimateToggleButton.isSelected()) {
            this.mAutoAnimateHistory = 0;
            this.mRequestObserver.finished();
        } else {
            this.mAutoAnimateHistory = -1;
        }
    }

    private void setupFractal() {
        this.mFractalContentPanel = new BufferedImagePanel(new BufferedImageProvider(){

            public BufferedImage get(JComponent j, BufferedImage old) {
                BufferedImage image = new BufferedImage(j.getWidth(), j.getHeight(), 2);
                return image;
            }
        }, this.mMandel);
        this.mFractalContentPanel.setRequestObserver(this.mRequestObserver);
        this.progressBar.setVisible(true);
        this.mBufferImagePanelContainer.setLayout(new GridLayout());
        this.mBufferImagePanelContainer.add(this.mFractalContentPanel);
        this.mMaxDepthSpinner.setValue(64);
        this.mChunksSpinner.setValue(16);
        this.mFractalContentPanel.addZoomListener(new BufferedImagePanel.ZoomListener(){

            public void zoomTo(Rectangle r) {
                if (FractalView.this.mAutoAnimateHistory == -1) {
                    ComplexArea displayedarea = FractalView.this.mMandel.getDisplayedArea(FractalView.this.mFractalContentPanel.getSize());
                    SnapshotPanel snp = new SnapshotPanel(FractalView.this.mFractalContentPanel, FractalView.this.mMandel, displayedarea);
                    FractalView.this.mSnapshotsPanel.addSnapshot(snp);
                    FractalView.this.mZoomHistory.add(FractalView.this.mMandel.getDisplayedArea(FractalView.this.mFractalContentPanel.getSize()));
                    FractalView.this.mMandel.zoomTo(FractalView.this.mFractalContentPanel.getSize(), r);
                    FractalView.this.mFractalContentPanel.updateContent();
                }
            }
        });
    }
}

