/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.impl.bundle.obr.resource;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.kxml2.io.KXmlParser;
import org.osgi.impl.bundle.obr.resource.CapabilityImpl;
import org.osgi.impl.bundle.obr.resource.RequirementImpl;
import org.osgi.impl.bundle.obr.resource.ResourceImpl;
import org.osgi.impl.bundle.obr.resource.VersionRange;
import org.osgi.service.obr.Repository;
import org.osgi.service.obr.Resource;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class RepositoryImpl
implements Repository {
    transient Set resources = new HashSet();
    URL url;
    String date;
    Set visited = new HashSet();
    static final Resource[] EMPTY_RESOURCE = new Resource[0];
    String name = "Untitled";
    long lastModified;
    Exception exception;
    int ranking = 0;

    public RepositoryImpl(URL url) {
        this.url = url;
    }

    public boolean refresh() {
        this.exception = null;
        try {
            this.resources.clear();
            this.parseDocument(this.url);
            this.visited = null;
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.exception = e;
            return false;
        }
    }

    private void parseRepository(XmlPullParser parser) throws Exception {
        try {
            parser.require(0, null, null);
            parser.nextTag();
            if (parser.getName().equals("bundles")) {
                this.parseOscar(parser);
            } else {
                parser.require(2, null, "repository");
                this.date = parser.getAttributeValue(null, "lastmodified");
                this.name = parser.getAttributeValue(null, "name");
                if (this.name == null) {
                    this.name = "Untitled";
                }
                while (parser.nextTag() == 2) {
                    if (parser.getName().equals("resource")) {
                        ResourceImpl resource = new ResourceImpl(this, parser);
                        this.resources.add(resource);
                        continue;
                    }
                    if (parser.getName().equals("referral")) {
                        this.referral(parser);
                        continue;
                    }
                    throw new IllegalArgumentException("Invalid tag in repository: " + this.url + " " + parser.getName());
                }
                parser.require(3, null, "repository");
            }
        }
        catch (XmlPullParserException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("XML unregognized around: " + e.getLineNumber() + " " + e.getMessage());
        }
    }

    private void parseOscar(XmlPullParser parser) throws Exception {
        block23: {
            parser.require(2, null, "bundles");
            while (true) {
                int event;
                if ((event = parser.next()) == 4) {
                    event = parser.next();
                }
                if (event != 2) break block23;
                ResourceImpl resource = new ResourceImpl(this);
                if (parser.getName().equals("bundle")) {
                    while (parser.nextTag() == 2) {
                        String key = parser.getName();
                        if (key.equals("import-package")) {
                            RequirementImpl requirement = new RequirementImpl("package");
                            requirement.setOptional(false);
                            requirement.setMultiple(false);
                            String p = parser.getAttributeValue(null, "package");
                            StringBuffer sb = new StringBuffer();
                            sb.append("(&(package=");
                            sb.append(p);
                            sb.append(")");
                            String version = parser.getAttributeValue(null, "specification-version");
                            VersionRange v = new VersionRange("0");
                            if (version != null) {
                                sb.append("(version=");
                                v = new VersionRange(version);
                                sb.append(v);
                                sb.append(")");
                            }
                            sb.append(")");
                            requirement.setFilter(sb.toString());
                            requirement.setComment("Import-Package: " + p + ";" + v);
                            resource.addRequirement(requirement);
                            parser.nextTag();
                            continue;
                        }
                        if (key.equals("export-package")) {
                            CapabilityImpl capability = new CapabilityImpl("package");
                            capability.addProperty("package", parser.getAttributeValue(null, "package"));
                            String version = parser.getAttributeValue(null, "specification-version");
                            if (version != null) {
                                capability.addProperty("version", new VersionRange(version));
                            }
                            resource.addCapability(capability);
                            parser.nextTag();
                            continue;
                        }
                        String value = parser.nextText().trim();
                        if (key.equals("bundle-sourceurl")) {
                            resource.setSource(new URL(value));
                            continue;
                        }
                        if (key.equals("bundle-docurl")) {
                            resource.setDocumentation(new URL(value));
                            continue;
                        }
                        if (key.equals("bundle-updatelocation")) {
                            resource.setURL(new URL(value));
                            continue;
                        }
                        if (key.equals("bundle-description")) {
                            resource.setDescription(value);
                            continue;
                        }
                        if (key.equals("bundle-category")) {
                            resource.addCategory(value);
                            continue;
                        }
                        if (key.equals("bundle-name")) {
                            resource.setName(value);
                            resource.setPresentationName(value);
                            continue;
                        }
                        if (key.equals("bundle-version")) {
                            resource.setVersion(new VersionRange(value));
                            continue;
                        }
                        resource.put(key, value);
                    }
                    this.resources.add(resource);
                    parser.require(3, null, "bundle");
                    continue;
                }
                if (parser.getName().equals("repository")) {
                    parser.require(2, null, "repository");
                    while (parser.nextTag() == 2) {
                        String tag = parser.getName();
                        if (tag.equals("name")) {
                            String name = parser.nextText();
                            if (this.name != null) continue;
                            this.name = name.trim();
                            continue;
                        }
                        if (tag.equals("url")) {
                            parser.nextText().trim();
                            continue;
                        }
                        if (tag.equals("date")) {
                            parser.nextText().trim();
                            continue;
                        }
                        if (tag.equals("extern-repositories")) {
                            parser.require(2, null, "extern-repositories");
                            while (parser.nextTag() == 2) {
                                if (parser.getName().equals("url")) {
                                    this.parseDocument(new URL(parser.nextText().trim()));
                                    continue;
                                }
                                throw new IllegalArgumentException("Invalid tag in repository while parsing extern repositories: " + this.url + " " + parser.getName());
                            }
                            parser.require(3, null, "extern-repositories");
                            continue;
                        }
                        throw new IllegalArgumentException("Invalid tag in repository: " + this.url + " " + parser.getName());
                    }
                    parser.require(3, null, "repository");
                    continue;
                }
                if (!parser.getName().equals("dtd-version")) break;
                parser.nextText();
            }
            throw new IllegalArgumentException("Invalid tag in repository: " + this.url + " " + parser.getName());
        }
        parser.require(3, null, "bundles");
    }

    void referral(XmlPullParser parser) {
        try {
            parser.require(2, null, "referral");
            String path = parser.getAttributeValue(null, "url");
            URL url = new URL(this.url, path);
            this.parseDocument(url);
            parser.next();
            parser.require(3, null, "referral");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void parseDocument(URL url) throws IOException, XmlPullParserException, Exception {
        if (!this.visited.contains(url)) {
            this.visited.add(url);
            try {
                System.out.println("Visiting: " + url);
                InputStream in = null;
                if (url.getPath().endsWith(".zip")) {
                    ZipInputStream zin = new ZipInputStream(url.openStream());
                    ZipEntry entry = zin.getNextEntry();
                    while (entry != null) {
                        if (entry.getName().equals("repository.xml")) {
                            in = zin;
                            break;
                        }
                        entry = zin.getNextEntry();
                    }
                } else {
                    in = url.openStream();
                }
                InputStreamReader reader = new InputStreamReader(in);
                KXmlParser parser = new KXmlParser();
                parser.setInput((Reader)reader);
                this.parseRepository((XmlPullParser)parser);
            }
            catch (MalformedURLException e) {
                System.out.println("Cannot create connection to url");
            }
        }
    }

    public URL getURL() {
        return this.url;
    }

    public Collection getResourceList() {
        return this.resources;
    }

    public Resource[] getResources() {
        return this.getResourceList().toArray(EMPTY_RESOURCE);
    }

    public String getName() {
        return this.name;
    }

    public Resource getResource(String id) {
        for (ResourceImpl resource : this.getResourceList()) {
            if (!resource.getId().equals(id)) continue;
            return resource;
        }
        return null;
    }

    public long getLastModified() {
        return this.lastModified;
    }

    public int getRanking() {
        return this.ranking;
    }

    public void setRanking(int ranking) {
        this.ranking = ranking;
    }
}

