/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.registry.net;

import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Properties;
import org.bundlebee.registry.impl.RegistryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiCastMessage {
    private static Logger LOG = LoggerFactory.getLogger(MultiCastMessage.class);
    public static final String PROPERTYKEY_TYPE = "type";
    public static final String PROPERTYKEY_URL = "url";
    public static final String PROPERTYKEY_NAME = "name";
    public static final String PROPERTYKEY_STATE = "state";
    public static final String PROPERTYKEY_SENDER = "sender";
    public static final String PROPERTYKEY_RECEIVER = "receiver";
    public static final String PROPERTYKEY_FREE_MEMORY = "free_memory";
    public static final String PROPERTYKEY_MAX_MEMORY = "max_memory";
    private Long nodeId;
    private String fallback = null;
    private Properties values;
    private Operation operation;
    private Direction direction;

    public MultiCastMessage() {
        this.nodeId = null;
        this.values = new Properties();
        this.values.setProperty(PROPERTYKEY_TYPE, "");
        this.operation = Operation.ADD;
        this.direction = Direction.OUT;
    }

    public MultiCastMessage(String nodeId, Properties values) {
        this(Long.parseLong(nodeId), values);
    }

    public MultiCastMessage(long nodeId, Properties values) {
        this.nodeId = nodeId;
        this.values = values;
        this.operation = Operation.ADD;
        this.direction = Direction.OUT;
    }

    public MultiCastMessage(long nodeId, Type type, String address) {
        this.nodeId = nodeId;
        this.values = new Properties();
        this.values.put(PROPERTYKEY_TYPE, type.toString());
        if (address != null) {
            this.values.put(PROPERTYKEY_SENDER, address);
        }
        this.direction = Direction.OUT;
        this.operation = Operation.ADD;
    }

    public MultiCastMessage(String data) {
        this.fromString(data);
    }

    public void setNodeId(Long nodeId) {
        this.nodeId = nodeId;
    }

    public Long getNodeId() {
        return this.nodeId;
    }

    public boolean hasNodeId() {
        return this.nodeId != null;
    }

    public void setValue(String key, String value) {
        this.values.setProperty(key, value);
    }

    public Properties getValues() {
        return this.values;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public void setOperation(Operation operation) {
        this.operation = operation;
    }

    public void setDirection(Direction direction) {
        this.direction = direction;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public boolean hasURL() {
        return this.values.containsKey(PROPERTYKEY_URL);
    }

    public URL getURL() {
        URL url = null;
        if (this.hasURL()) {
            try {
                url = new URL(this.values.getProperty(PROPERTYKEY_URL));
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
        }
        return url;
    }

    public boolean hasType() {
        return this.values.containsKey(PROPERTYKEY_TYPE);
    }

    public Type getType() {
        Type type = Type.MCM;
        if (this.hasType()) {
            try {
                type = Type.valueOf((String)this.values.get(PROPERTYKEY_TYPE));
            }
            catch (RuntimeException e) {
                LOG.debug(RegistryImpl.BUNDLE_MARKER, e.toString(), e);
            }
        }
        return type;
    }

    public InetAddress getSenderAddress() throws UnknownHostException {
        String sender = (String)this.values.get(PROPERTYKEY_SENDER);
        if (sender == null) {
            return null;
        }
        return InetAddress.getByName(sender.substring(0, sender.indexOf(58)));
    }

    public int getSenderPort() {
        String sender = this.values.getProperty(PROPERTYKEY_SENDER);
        if (sender == null) {
            LOG.debug("got port -1 for message " + this + ", == sender = " + sender);
            return -1;
        }
        return Integer.parseInt(sender.substring(sender.indexOf(58) + 1));
    }

    public boolean hasName() {
        return this.values.containsKey(PROPERTYKEY_NAME);
    }

    public String getName() {
        return this.values.getProperty(PROPERTYKEY_NAME);
    }

    public boolean hasState() {
        return this.values.containsKey(PROPERTYKEY_STATE);
    }

    public Integer getState() {
        Integer state = null;
        String stateString = this.values.getProperty(PROPERTYKEY_STATE);
        if (stateString != null) {
            try {
                state = Integer.parseInt(stateString);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return state;
    }

    public boolean hasFreeMemory() {
        return this.values.containsKey(PROPERTYKEY_FREE_MEMORY);
    }

    public Long getFreeMemory() {
        return this.getLong(PROPERTYKEY_FREE_MEMORY);
    }

    public boolean hasMaxMemory() {
        return this.values.containsKey(PROPERTYKEY_MAX_MEMORY);
    }

    public Long getMaxMemory() {
        return this.getLong(PROPERTYKEY_MAX_MEMORY);
    }

    private Long getLong(String key) {
        Long l = null;
        String lString = this.values.getProperty(key);
        if (lString != null) {
            try {
                l = Long.parseLong(lString);
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        return l;
    }

    public boolean hasSender() {
        return this.values.containsKey(PROPERTYKEY_SENDER);
    }

    public String toString() {
        if (this.fallback != null) {
            return this.fallback;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.nodeId + ",");
        sb.append((Object)((Object)this.operation) + ",");
        sb.append((Object)((Object)this.direction) + ",");
        sb.append(this.values.toString());
        if (LOG.isInfoEnabled()) {
            LOG.info(RegistryImpl.BUNDLE_MARKER, "toString() OUT.. [" + sb.toString() + "]");
        }
        return sb.toString();
    }

    public void fromString(String s) {
        if (LOG.isInfoEnabled()) {
            LOG.info(RegistryImpl.BUNDLE_MARKER, "toString() IN.. [" + s + "]");
        }
        this.fallback = null;
        this.nodeId = null;
        this.operation = null;
        this.direction = null;
        this.values = new Properties();
        s = s.replace("{", "");
        s = s.replace("}", "");
        String[] sArray = s.split(",");
        int index = 0;
        if (sArray.length < 2) {
            if (LOG.isInfoEnabled()) {
                LOG.info(RegistryImpl.BUNDLE_MARKER, "use fallback!");
            }
            this.fallback = s;
        } else {
            this.nodeId = Long.parseLong(sArray[index++]);
            this.operation = Operation.valueOf(sArray[index++]);
            this.direction = Direction.valueOf(sArray[index++]);
            for (int i = index; i < sArray.length; ++i) {
                String[] sProp = sArray[i].split("=");
                if (sProp.length <= 1) continue;
                this.values.put(sProp[0].trim(), sProp[1].trim());
            }
            this.toString();
        }
    }

    public boolean isValid() {
        return this.fallback == null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        HI,
        LS,
        MCM,
        REPOSITORY,
        MANAGER,
        BUNDLE,
        MEMORY,
        NODE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        IN,
        OUT;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Operation {
        ADD,
        REMOVE,
        UDPATE;

    }
}

