/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.remoteservicecall;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bundlebee.remoteservicecall.CallDescriptor;
import org.bundlebee.remoteservicecall.CallRuntimeException;
import org.bundlebee.remoteservicecall.ObjectInputStreamWithServiceClassLoader;
import org.bundlebee.remoteservicecall.ServiceNotAvailableException;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Call
implements Externalizable {
    private long callingServiceInstanceId;
    private long callingNodeId;
    private CallDescriptor mCallDesc;
    private Object[] parameters;
    private transient Object mService;
    private transient InvalidSyntaxException mInvSyntaxEx;
    private static final Map<String, Class> PRIMITIVETYPES = new HashMap<String, Class>(){
        {
            this.put("int", Integer.TYPE);
            this.put("short", Short.TYPE);
            this.put("byte", Byte.TYPE);
            this.put("long", Long.TYPE);
            this.put("char", Character.TYPE);
            this.put("float", Float.TYPE);
            this.put("double", Double.TYPE);
            this.put("boolean", Boolean.TYPE);
        }
    };

    public Call() {
    }

    public Call(long srvinstid, long nodeid, CallDescriptor calldesc, Object[] params) {
        this.callingServiceInstanceId = srvinstid;
        this.callingNodeId = nodeid;
        this.mCallDesc = calldesc;
        this.parameters = params;
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeLong(this.callingServiceInstanceId);
        oo.writeLong(this.callingNodeId);
        oo.writeObject(this.mCallDesc);
        oo.writeObject(this.parameters);
    }

    @Override
    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        assert (oi instanceof ObjectInputStreamWithServiceClassLoader);
        this.callingServiceInstanceId = oi.readLong();
        this.callingNodeId = oi.readLong();
        this.mCallDesc = (CallDescriptor)oi.readObject();
        try {
            this.mInvSyntaxEx = null;
            this.resolveService((ObjectInputStreamWithServiceClassLoader)oi);
            this.parameters = (Object[])oi.readObject();
        }
        catch (InvalidSyntaxException ex) {
            this.mInvSyntaxEx = ex;
        }
    }

    private void resolveService(ObjectInputStreamWithServiceClassLoader oi) throws InvalidSyntaxException {
        ServiceReference[] refs = oi.getBundleContext().getAllServiceReferences(this.mCallDesc.ServiceClassName, this.mCallDesc.ServiceFilter);
        if (null != refs && 0 != refs.length) {
            this.mService = oi.getBundleContext().getService(refs[0]);
            oi.useClassLoader(this.mService.getClass().getClassLoader());
        }
    }

    public Object execute() throws InvocationTargetException, ServiceNotAvailableException, CallRuntimeException {
        if (null != this.mInvSyntaxEx) {
            throw new ServiceNotAvailableException((Exception)((Object)this.mInvSyntaxEx));
        }
        if (null == this.mService) {
            throw new ServiceNotAvailableException("service not registered");
        }
        try {
            Class<?> serviceClass = this.mService.getClass();
            Class<?>[] parameterTypes = this.loadParameterClasses(serviceClass.getClassLoader(), this.mCallDesc.ParameterTypeNames);
            Method method = serviceClass.getMethod(this.mCallDesc.MethodName, parameterTypes);
            method.setAccessible(true);
            Object res = method.invoke(this.mService, this.parameters);
            return res;
        }
        catch (NoSuchMethodException ex) {
            throw new CallRuntimeException(ex);
        }
        catch (SecurityException ex) {
            throw new ServiceNotAvailableException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new ServiceNotAvailableException(ex);
        }
        catch (IllegalArgumentException ex) {
            throw new CallRuntimeException(ex);
        }
        catch (ClassNotFoundException ex) {
            throw new ServiceNotAvailableException(ex);
        }
    }

    private Class<?>[] loadParameterClasses(ClassLoader classLoader, String[] classNames) throws ClassNotFoundException {
        Class[] parameterTypes = new Class[classNames.length];
        for (int i = 0; i < classNames.length; ++i) {
            parameterTypes[i] = PRIMITIVETYPES.get(classNames[i]);
            if (null != parameterTypes[i]) continue;
            parameterTypes[i] = classLoader.loadClass(classNames[i]);
        }
        return parameterTypes;
    }
}

