/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.examples.fractal;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.bundlebee.examples.fractal.GlowingRoundRect;

public class GlowingBorderEffect {
    private final Rectangle mRect;
    private final long mStartTime;
    private static final long TTL = 1500000000L;
    private boolean mFinished = false;
    private static final int GLOWWIDTH = 4;

    public GlowingBorderEffect(Rectangle r) {
        this.mRect = r;
        this.mRect.grow(4, 4);
        this.mStartTime = System.nanoTime();
    }

    private void paintBorderGlow(Graphics2D g2, int glowWidth, float opacity) {
        GlowingRoundRect.paint(g2, this.mRect, 16, Color.YELLOW, glowWidth, opacity);
    }

    public void display(Graphics2D g2) {
        long dt = System.nanoTime() - this.mStartTime;
        this.mFinished = dt > 1500000000L;
        float opacity = (float)Math.max(0.0, 1.0 - (double)dt / 1.5E9);
        this.paintBorderGlow(g2, 4, opacity);
    }

    public boolean isFinished() {
        return this.mFinished;
    }

    public Rectangle getRectangle() {
        return this.mRect;
    }
}

