/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.core.joran.action;

import ch.qos.logback.core.boolex.JaninoEventEvaluatorBase;
import ch.qos.logback.core.boolex.Matcher;
import ch.qos.logback.core.joran.action.Action;
import ch.qos.logback.core.joran.spi.ActionException;
import ch.qos.logback.core.joran.spi.InterpretationContext;
import ch.qos.logback.core.util.OptionHelper;
import org.xml.sax.Attributes;

public class MatcherAction
extends Action {
    Matcher matcher;
    static final String REGEX = "regex";
    private boolean inError = false;

    public void begin(InterpretationContext ec, String localName, Attributes attributes) throws ActionException {
        this.matcher = null;
        this.inError = false;
        try {
            this.matcher = new Matcher();
            this.matcher.setContext(this.context);
            String matcherName = attributes.getValue("name");
            if (OptionHelper.isEmpty(matcherName)) {
                this.inError = true;
                this.addError("No matcher name specified");
                return;
            }
            this.matcher.setName(matcherName);
            this.addInfo("matcher named as [" + matcherName + "]");
            JaninoEventEvaluatorBase janinoEvaluator = (JaninoEventEvaluatorBase)ec.peekObject();
            janinoEvaluator.addMatcher(this.matcher);
            ec.pushObject(this.matcher);
        }
        catch (Exception oops) {
            this.inError = true;
            this.addError("Could not attach matcher to JaninoEvenyEvaluator", oops);
            throw new ActionException(1, (Throwable)oops);
        }
    }

    public void end(InterpretationContext ec, String name) {
        if (this.inError) {
            return;
        }
        if (OptionHelper.isEmpty(this.matcher.getRegex())) {
            this.addError("No regex specified for matcher named [" + this.matcher.getName() + "]");
            return;
        }
        this.matcher.start();
        Object o = ec.peekObject();
        if (o != this.matcher) {
            this.addWarn("The object at the of the stack is not the matcher named [" + this.matcher.getName() + "] pushed earlier.");
        } else {
            this.addInfo("Popping appender named [" + this.matcher.getName() + "] from the object stack");
            ec.popObject();
        }
    }
}

