/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.weaver.equinox;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.LoaderClassPath;
import javassist.NotFoundException;
import org.bundlebee.weaver.equinox.InstrumentedMethods;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleEntry;
import org.eclipse.osgi.baseadaptor.bundlefile.BundleFile;
import org.eclipse.osgi.baseadaptor.loader.ClasspathEntry;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Weaver {
    private static Logger LOG = LoggerFactory.getLogger(Weaver.class);
    private static final String RETURNOBJECT_VARNAME = "org_bundlebee_weaver_o";
    private static final String MANIFEST_PATH = "META-INF/MANIFEST.MF";
    private static final Map<CtClass, String> PRIMITIVE_RETURN_EXPRESSIONS;

    public byte[] weaveClass(byte[] classbytes, ClasspathEntry classpathEntry, ClassLoader bundleclassloader) {
        LoaderClassPath bundleloaderclasspath = new LoaderClassPath(bundleclassloader);
        ClassPool classPool = new ClassPool();
        try {
            classPool.appendClassPath(bundleloaderclasspath);
            CtClass ctClass = classPool.makeClass(new ByteArrayInputStream(classbytes));
            if (ctClass.isInterface()) {
                byte[] byArray = null;
                return byArray;
            }
            boolean needToMakeClass = false;
            String bundleSymbolicNameVersion = null;
            for (CtMethod method : ctClass.getDeclaredMethods()) {
                if (!InstrumentedMethods.mustInstrument(method)) continue;
                if (bundleSymbolicNameVersion == null) {
                    bundleSymbolicNameVersion = this.getBundleSymbolicNameVersion(classpathEntry);
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("BundleSymbolicNameVersion: " + bundleSymbolicNameVersion);
                    }
                }
                needToMakeClass = true;
                this.insertServiceCallAspect(method, bundleSymbolicNameVersion);
            }
            if (needToMakeClass) {
                byte[] byArray = ctClass.toBytecode();
                return byArray;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (IOException e) {
            LOG.error(e.toString(), e);
            throw new RuntimeException(e);
        }
        catch (CannotCompileException e) {
            LOG.error(e.toString(), e);
            throw new RuntimeException(e);
        }
        finally {
            classPool.removeClassPath(bundleloaderclasspath);
        }
    }

    private String getBundleSymbolicNameVersion(ClasspathEntry classpathEntry) {
        String nameVersion = null;
        try {
            BundleFile bundleFile = classpathEntry.getBundleFile();
            BundleEntry entry = bundleFile.getEntry(MANIFEST_PATH);
            if (entry != null) {
                Manifest manifest = new Manifest(entry.getInputStream());
                Attributes attributes = manifest.getMainAttributes();
                String symbolicName = attributes.getValue("Bundle-SymbolicName");
                String version = attributes.getValue("Bundle-Version");
                if (symbolicName != null) {
                    StringBuilder sb = new StringBuilder();
                    int semiColon = symbolicName.indexOf(59);
                    if (semiColon == -1) {
                        sb.append(symbolicName);
                    } else {
                        sb.append(symbolicName.substring(0, semiColon));
                    }
                    if (version != null) {
                        sb.append('/').append(version);
                    }
                    nameVersion = sb.toString();
                }
            }
        }
        catch (IOException e) {
            LOG.error(e.toString(), e);
        }
        return nameVersion;
    }

    private void insertServiceCallAspect(CtMethod method, String bundleSymbolicNameVersion) {
        try {
            String methodName = method.getName();
            if (LOG.isInfoEnabled()) {
                LOG.info("Instrumenting method: " + method.getLongName());
            }
            String returnExpression = this.getReturnExpression(method);
            String determineSignature = "javassist.runtime.Desc.useContextClassLoader = true;Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());";
            String o = RETURNOBJECT_VARNAME;
            String prelude = determineSignature + "Object " + o + " = org.bundlebee.weaver.ServiceCallAspect.tryRemote( $0, \"" + methodName + "\", \"" + bundleSymbolicNameVersion + "\", $sig, $args);\n" + "if( " + o + " != org.bundlebee.weaver.ServiceCallAspect.CANNOT_EXECUTE_REMOTELY ) { return " + returnExpression + "; }";
            String postlude = "org.bundlebee.weaver.ServiceCallAspect.finishLocal( $0, \"" + methodName + "\", $sig );";
            if (LOG.isDebugEnabled()) {
                LOG.debug("weaving before:\n" + prelude);
            }
            method.insertBefore(prelude);
            if (LOG.isDebugEnabled()) {
                LOG.debug("weaving after:\n" + postlude);
            }
            method.insertAfter(postlude, true);
        }
        catch (CannotCompileException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error(e.toString());
            }
            throw new RuntimeException(e);
        }
    }

    private String getReturnExpression(CtMethod method) {
        String returnValue = "";
        try {
            CtClass returnType = method.getReturnType();
            returnValue = PRIMITIVE_RETURN_EXPRESSIONS.get(returnType);
            if (null == returnValue) {
                returnValue = "(" + returnType.getName() + ")" + RETURNOBJECT_VARNAME;
            }
        }
        catch (NotFoundException e) {
            String mes = "Return type for method " + method.getName() + " could not be found.";
            LOG.error(mes, e);
            throw new RuntimeException(mes, e);
        }
        return returnValue;
    }

    static {
        ClassPool classPool = ClassPool.getDefault();
        classPool.importPackage("org.bundlebee.weaver");
        classPool.importPackage("javassist.runtime");
        PRIMITIVE_RETURN_EXPRESSIONS = new HashMap<CtClass, String>(){
            {
                this.put(CtClass.voidType, "");
                this.put(CtClass.intType, "((Integer)org_bundlebee_weaver_o).intValue()");
                this.put(CtClass.shortType, "((Short)org_bundlebee_weaver_o).shortValue()");
                this.put(CtClass.longType, "((Long)org_bundlebee_weaver_o).longValue()");
                this.put(CtClass.floatType, "((Float)org_bundlebee_weaver_o).floatValue()");
                this.put(CtClass.doubleType, "((Double)org_bundlebee_weaver_o).doubleValue()");
                this.put(CtClass.booleanType, "((Boolean)org_bundlebee_weaver_o).booleanValue()");
                this.put(CtClass.byteType, "((Byte)org_bundlebee_weaver_o).byteValue()");
                this.put(CtClass.charType, "((Character)org_bundlebee_weaver_o).charValue()");
            }
        };
    }
}

