/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.manager.impl;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.bundlebee.manager.impl.Activator;
import org.osgi.framework.BundleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BundleLifecycleServlet
extends HttpServlet {
    private static final Logger LOG = LoggerFactory.getLogger(BundleLifecycleServlet.class);
    private int successStatusCode = 200;

    protected BundleLifecycleServlet() {
    }

    public BundleLifecycleServlet(int successStatusCode) {
        this.successStatusCode = successStatusCode;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug(Activator.BUNDLE_MARKER, "Lifecycle request: " + request.getServletPath() + request.getPathInfo());
        }
        if (request.getPathInfo() == null || request.getPathInfo().length() < 2) {
            response.setStatus(400);
        } else {
            String[] nameVersion = request.getPathInfo().substring(1).split("/");
            if (nameVersion.length != 2) {
                response.setStatus(400);
            } else {
                String symbolicName = nameVersion[0];
                String version = nameVersion[1];
                try {
                    this.post(symbolicName, version);
                    response.setStatus(this.successStatusCode);
                }
                catch (BundleException e) {
                    LOG.error(Activator.BUNDLE_MARKER, e.toString(), (Throwable)e);
                    response.setStatus(500);
                    response.setContentType("text/plain");
                    e.printStackTrace(response.getWriter());
                }
            }
        }
    }

    public abstract void post(String var1, String var2) throws BundleException;
}

