/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.examples.fractal;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.SwingUtilities;
import org.bundlebee.examples.fractal.BufferedImagePanel;

public class AsynchronousContentRequest {
    private final BufferedImagePanel mTarget;
    private final BufferedImage mImage;
    private final Rectangle[] mRects;
    private boolean mCancelled = false;
    private final Observer mObserver;
    float mProgress = 0.0f;

    AsynchronousContentRequest(BufferedImagePanel target, BufferedImage i, Rectangle[] rects, Observer obs) {
        this.mTarget = target;
        this.mImage = i;
        this.mRects = rects;
        this.mObserver = obs;
        if (null != this.mObserver) {
            this.mObserver.started();
        }
    }

    public BufferedImage getBufferedImage() {
        return this.mImage;
    }

    public Rectangle[] getRectangles() {
        return this.mRects;
    }

    public void updated(Rectangle r, boolean intermediate) {
        if (!this.isCancelled()) {
            this.mTarget.update(r, intermediate);
        }
    }

    public boolean isCancelled() {
        return this.mCancelled;
    }

    synchronized void cancel() {
        this.mCancelled = true;
    }

    public synchronized void progress(float p) {
        this.mProgress += p;
        if (null != this.mObserver && !this.isCancelled()) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    AsynchronousContentRequest.this.mObserver.progressed(AsynchronousContentRequest.this.mProgress);
                    if (AsynchronousContentRequest.this.mProgress >= 1.0f) {
                        AsynchronousContentRequest.this.mObserver.finished();
                    }
                }
            });
        }
    }

    public static interface Observer {
        public void started();

        public void progressed(float var1);

        public void finished();
    }
}

