/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.registry.directory;

import org.bundlebee.registry.directory.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bundle
implements Comparable<Bundle> {
    private int state;
    private String name;
    private Node node;

    Bundle(Node node, String name, int state) {
        this.node = node;
        this.name = name;
        this.state = state;
    }

    Node getNode() {
        return this.node;
    }

    public int getState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Bundle bundle = (Bundle)o;
        if (this.state != bundle.state) {
            return false;
        }
        return !(this.name != null ? !this.name.equals(bundle.name) : bundle.name != null);
    }

    public int hashCode() {
        int result = this.state;
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Bundle that) {
        if (this.state != that.state) {
            return this.name.compareTo(that.name);
        }
        return this.state - that.state;
    }

    public String getStateDescription() {
        switch (this.state) {
            case 32: {
                return "ACTIVE";
            }
            case 2: {
                return "INSTALLED";
            }
            case 4: {
                return "RESOLVED";
            }
            case 8: {
                return "STARTING";
            }
            case 16: {
                return "STOPPING";
            }
            case 1: {
                return "UNINSTALLED";
            }
        }
        return "" + this.state;
    }

    public String toString() {
        return "Bundle[name=" + this.name + ",state=" + this.getStateDescription() + "]";
    }
}

