/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.weaver;

import org.bundlebee.registry.Registry;
import org.bundlebee.weaver.BundleStateDispatchStrategy;
import org.bundlebee.weaver.ServiceCallDispatchStrategy;
import org.bundlebee.weaver.ServiceCallStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatchStrategyFactory {
    private static Logger LOG = LoggerFactory.getLogger(DispatchStrategyFactory.class);
    private static final String SERVICE_CALL_DISPATCH_STRATEGY_PROPERTY_KEY = "org.bundlebee.weaver.servicecalldispatchstrategy";
    private static final String SERVICE_CALL_DISPATCH_STRATEGY_CLASS = System.getProperty("org.bundlebee.weaver.servicecalldispatchstrategy", BundleStateDispatchStrategy.class.getName());

    static ServiceCallDispatchStrategy create(Registry reg, ServiceCallStats stats) {
        ServiceCallDispatchStrategy strat;
        try {
            strat = (ServiceCallDispatchStrategy)Class.forName(SERVICE_CALL_DISPATCH_STRATEGY_CLASS).newInstance();
        }
        catch (Exception e) {
            LOG.error(e.toString(), e);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Using " + BundleStateDispatchStrategy.class.getName());
            }
            strat = new BundleStateDispatchStrategy();
        }
        strat.setRegistry(reg);
        strat.setServiceCallStats(stats);
        return strat;
    }
}

