/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.registry.directory;

import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.bundlebee.registry.directory.Bundle;
import org.bundlebee.registry.directory.Grid;
import org.bundlebee.registry.directory.Node;
import org.bundlebee.registry.impl.RegistryImpl;
import org.bundlebee.registry.net.MultiCastMessage;
import org.bundlebee.registry.net.MultiCastMessageListener;
import org.bundlebee.registry.net.MultiCastMessageSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegistryDirectory
implements MultiCastMessageSource,
MultiCastMessageListener {
    private static Logger LOG = LoggerFactory.getLogger(RegistryDirectory.class);
    private Map<String, Properties> mainDir;
    private Grid grid = new Grid();
    private Set<MultiCastMessageListener> multiCastMessageListeners = new HashSet<MultiCastMessageListener>();

    public RegistryDirectory() {
        this.mainDir = new HashMap<String, Properties>();
    }

    public synchronized void set(MultiCastMessage message) {
        String key = message.getNodeId().toString();
        MultiCastMessage.Operation operation = message.getOperation();
        if (this.mainDir.containsKey(key)) {
            this.mainDir.remove(key);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(RegistryImpl.BUNDLE_MARKER, "=> operation = " + (Object)((Object)operation) + ", type = " + (Object)((Object)message.getType()));
        }
        switch (operation) {
            case REMOVE: {
                this.remove(message);
                break;
            }
            case ADD: {
                this.add(message);
                break;
            }
            case UDPATE: {
                break;
            }
        }
        if (!MultiCastMessage.Direction.IN.equals((Object)message.getDirection())) {
            message.setDirection(MultiCastMessage.Direction.OUT);
            if (LOG.isDebugEnabled()) {
                LOG.debug("RegistryDirectory.set(): " + message);
            }
            this.fireMessage(message);
        } else {
            LOG.debug(RegistryImpl.BUNDLE_MARKER, "Not propagated: " + message);
        }
    }

    public void addMultiCastMessageListener(MultiCastMessageListener multiCastMessageListener) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Adding " + multiCastMessageListener);
        }
        this.multiCastMessageListeners.add(multiCastMessageListener);
    }

    private void fireMessage(MultiCastMessage multiCastMessage) {
        for (MultiCastMessageListener multiCastMessageListener : this.multiCastMessageListeners) {
            multiCastMessageListener.processMessage(multiCastMessage);
        }
        if (this.multiCastMessageListeners.isEmpty() && LOG.isDebugEnabled()) {
            LOG.debug(RegistryImpl.BUNDLE_MARKER, "No MultiCastMessageListeners registered.");
        }
    }

    public void processMessage(MultiCastMessage multiCastMessage) {
        this.set(multiCastMessage);
    }

    private void add(MultiCastMessage message) {
        if (message.hasType()) {
            switch (message.getType()) {
                case REPOSITORY: {
                    this.addRepository(message);
                    break;
                }
                case MANAGER: {
                    this.addManager(message);
                    break;
                }
                case BUNDLE: {
                    this.addBundle(message);
                    break;
                }
                case MEMORY: {
                    this.addMemory(message);
                }
                case HI: 
                case NODE: {
                    this.addNode(message);
                }
            }
        }
        this.mainDir.put(message.getNodeId() + "-" + (Object)((Object)message.getType()), message.getValues());
    }

    private void addManager(MultiCastMessage message) {
        if (message.hasURL() && message.hasNodeId()) {
            URL url = message.getURL();
            this.getNode(message).setManagerURL(url);
            if (LOG.isInfoEnabled()) {
                LOG.info(RegistryImpl.BUNDLE_MARKER, "adding Manager: " + url.toString());
            }
        }
    }

    private void addRepository(MultiCastMessage message) {
        if (message.hasURL() && message.hasNodeId()) {
            URL url = message.getURL();
            this.getNode(message).setRepositoryURL(url);
            if (LOG.isInfoEnabled()) {
                LOG.info(RegistryImpl.BUNDLE_MARKER, "adding Repository: " + url.toString());
            }
        }
    }

    private void addBundle(MultiCastMessage message) {
        if (message.hasName() && message.hasState() && message.hasNodeId()) {
            Node node = this.getNode(message);
            Bundle bundle = node.newBundle(message.getName(), message.getState());
            node.addBundle(bundle);
            if (LOG.isInfoEnabled()) {
                LOG.info(RegistryImpl.BUNDLE_MARKER, "adding Bundle: " + bundle);
            }
        }
    }

    private void addMemory(MultiCastMessage message) {
        if (message.hasMaxMemory() && message.hasFreeMemory() && message.hasNodeId()) {
            Node node = this.getNode(message);
            node.setMaxMemory(message.getMaxMemory());
            node.setFreeMemory(message.getFreeMemory());
            if (LOG.isInfoEnabled()) {
                LOG.info(RegistryImpl.BUNDLE_MARKER, "adding Memory: " + message.getFreeMemory() + "/" + message.getMaxMemory());
            }
        }
    }

    private void addNode(MultiCastMessage message) {
        if (message.hasSender() && message.hasNodeId()) {
            try {
                Node node = this.getNode(message);
                node.setPrivatePort(message.getSenderPort());
                node.setPrivateAddress(message.getSenderAddress());
                if (LOG.isInfoEnabled()) {
                    LOG.info(RegistryImpl.BUNDLE_MARKER, "adding Node: " + message.getSenderAddress() + ":" + message.getSenderPort());
                }
            }
            catch (UnknownHostException e) {
                LOG.error(e.toString(), e);
            }
        }
    }

    private void remove(MultiCastMessage message) {
        if (message.hasType()) {
            switch (message.getType()) {
                case REPOSITORY: {
                    this.removeRepository(message);
                    break;
                }
                case MANAGER: {
                    this.removeManager(message);
                    break;
                }
                case BUNDLE: {
                    this.removeBundle(message);
                    break;
                }
                case NODE: {
                    this.removeNode(message);
                }
            }
        }
        this.mainDir.remove(message.getNodeId() + "-" + (Object)((Object)message.getType()));
    }

    private void removeManager(MultiCastMessage message) {
        if (message.hasURL() && message.hasNodeId()) {
            URL url = message.getURL();
            this.getNode(message).setManagerURL(null);
            if (LOG.isInfoEnabled()) {
                LOG.info(RegistryImpl.BUNDLE_MARKER, "removing Manager: " + url.toString());
            }
        }
    }

    private void removeRepository(MultiCastMessage message) {
        if (message.hasURL() && message.hasNodeId()) {
            URL url = message.getURL();
            this.getNode(message).setRepositoryURL(null);
            if (LOG.isInfoEnabled()) {
                LOG.info(RegistryImpl.BUNDLE_MARKER, "removing Repository: " + url.toString());
            }
        }
    }

    private void removeBundle(MultiCastMessage message) {
        if (message.hasName() && message.hasNodeId()) {
            Node node = this.getNode(message);
            node.removeBundle(message.getName());
            if (LOG.isInfoEnabled()) {
                LOG.info(RegistryImpl.BUNDLE_MARKER, "removing Bundle: " + message.getName());
            }
        }
    }

    private void removeNode(MultiCastMessage message) {
        if (message.hasNodeId()) {
            this.grid.unregisterNode(message.getNodeId());
            if (LOG.isInfoEnabled()) {
                LOG.info(RegistryImpl.BUNDLE_MARKER, "removing Node: " + message.getNodeId());
            }
        }
    }

    private Node getNode(MultiCastMessage message) {
        long nodeId = message.getNodeId();
        Node node = this.grid.getNode(nodeId);
        if (node == null) {
            node = this.grid.newNode(nodeId);
            this.grid.addNode(node);
        }
        return node;
    }

    public void showContent() {
        if (LOG.isInfoEnabled()) {
            LOG.info(RegistryImpl.BUNDLE_MARKER, "=== UPDATED Directory ===");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(RegistryImpl.BUNDLE_MARKER, "= " + this.getList().length + " entries ======================================");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug(RegistryImpl.BUNDLE_MARKER, this.mainDir.toString());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(RegistryImpl.BUNDLE_MARKER, "==================================================");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(RegistryImpl.BUNDLE_MARKER, "= Managers ");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(RegistryImpl.BUNDLE_MARKER, "= " + this.getGrid().getManagers().size() + " entries ======================================");
        }
        for (URL url : this.getGrid().getManagers()) {
            if (!LOG.isInfoEnabled()) continue;
            LOG.info(RegistryImpl.BUNDLE_MARKER, url.toString());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(RegistryImpl.BUNDLE_MARKER, "==================================================");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(RegistryImpl.BUNDLE_MARKER, "= Repositories ");
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(RegistryImpl.BUNDLE_MARKER, "= " + this.getGrid().getRepositories().size() + " entries ======================================");
        }
        for (URL url : this.getGrid().getRepositories()) {
            if (!LOG.isInfoEnabled()) continue;
            LOG.info(RegistryImpl.BUNDLE_MARKER, url.toString());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info(RegistryImpl.BUNDLE_MARKER, "==================================================");
        }
    }

    private MultiCastMessage get(String key) {
        if (this.mainDir.containsKey(key)) {
            return new MultiCastMessage(key, this.mainDir.get(key));
        }
        return new MultiCastMessage();
    }

    public synchronized MultiCastMessage[] getList() {
        ArrayList<MultiCastMessage> messages = new ArrayList<MultiCastMessage>();
        for (Node node : this.grid.getNodes()) {
            MultiCastMessage message;
            long nodeId = node.getId();
            if (node.getRepositoryURL() != null) {
                message = RegistryDirectory.createNodeMessage(node.getPrivateAddressAndPort(), MultiCastMessage.Operation.ADD);
                message.setNodeId(nodeId);
                messages.add(message);
            }
            if (node.getRepositoryURL() != null) {
                message = RegistryDirectory.createMultiCastURLMessage(MultiCastMessage.Type.REPOSITORY, node.getRepositoryURL(), MultiCastMessage.Operation.ADD);
                message.setNodeId(nodeId);
                messages.add(message);
            }
            if (node.getManagerURL() != null) {
                message = RegistryDirectory.createMultiCastURLMessage(MultiCastMessage.Type.MANAGER, node.getManagerURL(), MultiCastMessage.Operation.ADD);
                message.setNodeId(nodeId);
                messages.add(message);
            }
            if (node.getFreeMemory() != 0L && node.getMaxMemory() != 0L) {
                message = RegistryDirectory.createMultiCastMemoryMessage(node.getFreeMemory(), node.getMaxMemory(), MultiCastMessage.Operation.ADD);
                message.setNodeId(nodeId);
                messages.add(message);
            }
            for (Bundle bundle : node.getBundles()) {
                MultiCastMessage message2 = RegistryDirectory.createMultiCastBundleMessage(bundle.getName(), bundle.getState(), MultiCastMessage.Operation.ADD);
                message2.setNodeId(nodeId);
                messages.add(message2);
            }
        }
        return messages.toArray(new MultiCastMessage[messages.size()]);
    }

    public Grid getGrid() {
        return this.grid;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.mainDir.keySet()) {
            sb.append(new MultiCastMessage(s, this.mainDir.get(s)).toString() + "\n");
        }
        return sb.toString();
    }

    public void setURLMessage(MultiCastMessage.Type type, URL url, MultiCastMessage.Operation operation) {
        this.set(RegistryDirectory.createMultiCastURLMessage(type, url, operation));
    }

    private static MultiCastMessage createMultiCastURLMessage(MultiCastMessage.Type type, URL url, MultiCastMessage.Operation operation) {
        Properties properties = new Properties();
        properties.setProperty("type", type.toString());
        properties.setProperty("url", url.toString());
        MultiCastMessage multiCastMessage = new MultiCastMessage(RegistryImpl.getInstance().getNodeId(), properties);
        multiCastMessage.setOperation(operation);
        return multiCastMessage;
    }

    public void setMemoryMessage(long freeMemory, long maxMemory, MultiCastMessage.Operation operation) {
        this.set(RegistryDirectory.createMultiCastMemoryMessage(freeMemory, maxMemory, operation));
    }

    private static MultiCastMessage createMultiCastMemoryMessage(long freeMemory, long maxMemory, MultiCastMessage.Operation operation) {
        Properties properties = new Properties();
        properties.setProperty("type", MultiCastMessage.Type.MEMORY.toString());
        properties.setProperty("free_memory", Long.toString(freeMemory));
        properties.setProperty("max_memory", Long.toString(maxMemory));
        MultiCastMessage multiCastMessage = new MultiCastMessage(RegistryImpl.getInstance().getNodeId(), properties);
        multiCastMessage.setOperation(operation);
        return multiCastMessage;
    }

    public void setBundleMessage(String name, int state, MultiCastMessage.Operation operation) {
        this.set(RegistryDirectory.createMultiCastBundleMessage(name, state, operation));
    }

    private static MultiCastMessage createMultiCastBundleMessage(String name, int state, MultiCastMessage.Operation operation) {
        Properties properties = new Properties();
        properties.setProperty("type", MultiCastMessage.Type.BUNDLE.toString());
        properties.setProperty("name", name);
        properties.setProperty("state", Integer.toString(state));
        MultiCastMessage multiCastMessage = new MultiCastMessage(RegistryImpl.getInstance().getNodeId(), properties);
        multiCastMessage.setOperation(operation);
        return multiCastMessage;
    }

    public void setBundleMessage(String name, MultiCastMessage.Operation operation) {
        this.set(RegistryDirectory.createMultiCastBundleMessage(name, operation));
    }

    private static MultiCastMessage createMultiCastBundleMessage(String name, MultiCastMessage.Operation operation) {
        Properties properties = new Properties();
        properties.setProperty("type", MultiCastMessage.Type.BUNDLE.toString());
        properties.setProperty("name", name);
        MultiCastMessage multiCastMessage = new MultiCastMessage(RegistryImpl.getInstance().getNodeId(), properties);
        multiCastMessage.setOperation(operation);
        return multiCastMessage;
    }

    public void setNodeMessage(MultiCastMessage.Operation operation) {
        this.set(RegistryDirectory.createNodeMessage(null, operation));
    }

    public void setNodeMessage(String address, MultiCastMessage.Operation operation) {
        this.set(RegistryDirectory.createNodeMessage(address, operation));
    }

    private static MultiCastMessage createNodeMessage(String address, MultiCastMessage.Operation operation) {
        Properties properties = new Properties();
        if (address != null) {
            properties.setProperty("sender", address);
        }
        properties.setProperty("type", MultiCastMessage.Type.NODE.toString());
        MultiCastMessage multiCastMessage = new MultiCastMessage(RegistryImpl.getInstance().getNodeId(), properties);
        multiCastMessage.setOperation(operation);
        return multiCastMessage;
    }

    public void setHiMessage() {
        this.set(RegistryDirectory.createHiMessage());
    }

    private static MultiCastMessage createHiMessage() {
        Node node = RegistryImpl.getInstance().getGrid().getNode(RegistryImpl.getInstance().getNodeId());
        assert (node != null);
        return new MultiCastMessage(RegistryImpl.getInstance().getNodeId(), MultiCastMessage.Type.HI, node.getPrivateAddressAndPort());
    }
}

