/*
 * FractalView.java
 */

package org.bundlebee.examples.fractal;

import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import javax.swing.JComponent;
import org.jdesktop.application.Action;
import org.jdesktop.application.ResourceMap;
import org.jdesktop.application.SingleFrameApplication;
import org.jdesktop.application.FrameView;
import org.jdesktop.application.TaskMonitor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Timer;
import javax.swing.Icon;
import javax.swing.JDialog;
import javax.swing.JFrame;
import org.bundlebee.examples.fractal.mandelbrot.ComplexArea;
import org.bundlebee.examples.fractal.mandelbrot.MandelbrotContentProvider;

/**
 * The application's main frame.
 */
public class FractalView extends FrameView {

	private int mAutoAnimateHistory = -1;

    public FractalView(SingleFrameApplication app) {
        super(app);

        initComponents();

        // status bar initialization - message timeout, idle icon and busy animation, etc
        ResourceMap resourceMap = getResourceMap();
        int messageTimeout = resourceMap.getInteger("StatusBar.messageTimeout");
        messageTimer = new Timer(messageTimeout, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                statusMessageLabel.setText("");
            }
        });
        messageTimer.setRepeats(false);
        int busyAnimationRate = resourceMap.getInteger("StatusBar.busyAnimationRate");
        for (int i = 0; i < busyIcons.length; i++) {
            busyIcons[i] = resourceMap.getIcon("StatusBar.busyIcons[" + i + "]");
        }
        busyIconTimer = new Timer(busyAnimationRate, new ActionListener() {
            public void actionPerformed(ActionEvent e) {
                busyIconIndex = (busyIconIndex + 1) % busyIcons.length;
                statusAnimationLabel.setIcon(busyIcons[busyIconIndex]);
            }
        });
        idleIcon = resourceMap.getIcon("StatusBar.idleIcon");
        statusAnimationLabel.setIcon(idleIcon);
        progressBar.setVisible(false);

        // connecting action tasks to status bar via TaskMonitor
        TaskMonitor taskMonitor = new TaskMonitor(getApplication().getContext());
        taskMonitor.addPropertyChangeListener(new java.beans.PropertyChangeListener() {
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                String propertyName = evt.getPropertyName();
                if ("started".equals(propertyName)) {
                    if (!busyIconTimer.isRunning()) {
                        statusAnimationLabel.setIcon(busyIcons[0]);
                        busyIconIndex = 0;
                        busyIconTimer.start();
                    }
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(true);
                } else if ("done".equals(propertyName)) {
                    busyIconTimer.stop();
                    statusAnimationLabel.setIcon(idleIcon);
                    progressBar.setVisible(false);
                    progressBar.setValue(0);
                } else if ("message".equals(propertyName)) {
                    String text = (String)(evt.getNewValue());
                    statusMessageLabel.setText((text == null) ? "" : text);
                    messageTimer.restart();
                } else if ("progress".equals(propertyName)) {
                    int value = (Integer)(evt.getNewValue());
                    progressBar.setVisible(true);
                    progressBar.setIndeterminate(false);
                    progressBar.setValue(value);
                }
            }
        });

		setupFractal();

    }

    @Action
    public void showAboutBox() {
        if (aboutBox == null) {
            JFrame mainFrame = FractalApp.getApplication().getMainFrame();
            aboutBox = new FractalAboutBox(mainFrame);
            aboutBox.setLocationRelativeTo(mainFrame);
        }
        FractalApp.getApplication().show(aboutBox);
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        mainPanel = new javax.swing.JPanel();
        mBufferImagePanelContainer = new javax.swing.JPanel();
        mControlUI = new javax.swing.JPanel();
        mMaxDepthPanel = new javax.swing.JPanel();
        mMaxDepthSpinner = new javax.swing.JSpinner();
        jLabel1 = new javax.swing.JLabel();
        mChunksPanel = new javax.swing.JPanel();
        jLabel2 = new javax.swing.JLabel();
        mChunksSpinner = new javax.swing.JSpinner();
        mZoomBackButton = new javax.swing.JButton();
        mSnapshotsScrollPane = new javax.swing.JScrollPane();
        mSnapshotsPanel = new org.bundlebee.examples.fractal.SnapshotsPanel();
        mAutoAnimateToggleButton = new javax.swing.JToggleButton();
        menuBar = new javax.swing.JMenuBar();
        javax.swing.JMenu fileMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem exitMenuItem = new javax.swing.JMenuItem();
        javax.swing.JMenu helpMenu = new javax.swing.JMenu();
        javax.swing.JMenuItem aboutMenuItem = new javax.swing.JMenuItem();
        statusPanel = new javax.swing.JPanel();
        javax.swing.JSeparator statusPanelSeparator = new javax.swing.JSeparator();
        statusMessageLabel = new javax.swing.JLabel();
        statusAnimationLabel = new javax.swing.JLabel();
        progressBar = new javax.swing.JProgressBar();
        minnoQLabel = new javax.swing.JLabel();

        mainPanel.setName("mainPanel"); // NOI18N

        mBufferImagePanelContainer.setName("mBufferImagePanelContainer"); // NOI18N

        org.jdesktop.layout.GroupLayout mBufferImagePanelContainerLayout = new org.jdesktop.layout.GroupLayout(mBufferImagePanelContainer);
        mBufferImagePanelContainer.setLayout(mBufferImagePanelContainerLayout);
        mBufferImagePanelContainerLayout.setHorizontalGroup(
            mBufferImagePanelContainerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 596, Short.MAX_VALUE)
        );
        mBufferImagePanelContainerLayout.setVerticalGroup(
            mBufferImagePanelContainerLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 230, Short.MAX_VALUE)
        );

        mControlUI.setName("mControlUI"); // NOI18N

        mMaxDepthPanel.setName("mMaxDepthPanel"); // NOI18N

        mMaxDepthSpinner.setName("mMaxDepthSpinner"); // NOI18N
        mMaxDepthSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                mMaxDepthSpinnerStateChanged(evt);
            }
        });

        jLabel1.setDisplayedMnemonic('d');
        jLabel1.setLabelFor(mMaxDepthSpinner);
        org.jdesktop.application.ResourceMap resourceMap = org.jdesktop.application.Application.getInstance(org.bundlebee.examples.fractal.FractalApp.class).getContext().getResourceMap(FractalView.class);
        jLabel1.setText(resourceMap.getString("jLabel1.text")); // NOI18N
        jLabel1.setName("jLabel1"); // NOI18N

        org.jdesktop.layout.GroupLayout mMaxDepthPanelLayout = new org.jdesktop.layout.GroupLayout(mMaxDepthPanel);
        mMaxDepthPanel.setLayout(mMaxDepthPanelLayout);
        mMaxDepthPanelLayout.setHorizontalGroup(
            mMaxDepthPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, mMaxDepthPanelLayout.createSequentialGroup()
                .add(jLabel1)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(mMaxDepthSpinner, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 66, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );
        mMaxDepthPanelLayout.setVerticalGroup(
            mMaxDepthPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(mMaxDepthSpinner, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 28, Short.MAX_VALUE)
            .add(jLabel1, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 28, Short.MAX_VALUE)
        );

        mChunksPanel.setName("mChunksPanel"); // NOI18N

        jLabel2.setDisplayedMnemonic('c');
        jLabel2.setLabelFor(mChunksSpinner);
        jLabel2.setText(resourceMap.getString("jLabel2.text")); // NOI18N
        jLabel2.setName("jLabel2"); // NOI18N

        mChunksSpinner.setName("mChunksSpinner"); // NOI18N
        mChunksSpinner.addChangeListener(new javax.swing.event.ChangeListener() {
            public void stateChanged(javax.swing.event.ChangeEvent evt) {
                mChunksSpinnerStateChanged(evt);
            }
        });

        org.jdesktop.layout.GroupLayout mChunksPanelLayout = new org.jdesktop.layout.GroupLayout(mChunksPanel);
        mChunksPanel.setLayout(mChunksPanelLayout);
        mChunksPanelLayout.setHorizontalGroup(
            mChunksPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(mChunksPanelLayout.createSequentialGroup()
                .add(jLabel2)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                .add(mChunksSpinner, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 70, Short.MAX_VALUE))
        );
        mChunksPanelLayout.setVerticalGroup(
            mChunksPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(jLabel2, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 25, Short.MAX_VALUE)
            .add(mChunksSpinner, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 25, Short.MAX_VALUE)
        );

        mZoomBackButton.setMnemonic('o');
        mZoomBackButton.setText(resourceMap.getString("mZoomBackButton.text")); // NOI18N
        mZoomBackButton.setName("mZoomBackButton"); // NOI18N
        mZoomBackButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mZoomBackButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout mControlUILayout = new org.jdesktop.layout.GroupLayout(mControlUI);
        mControlUI.setLayout(mControlUILayout);
        mControlUILayout.setHorizontalGroup(
            mControlUILayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, mControlUILayout.createSequentialGroup()
                .add(mChunksPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 366, Short.MAX_VALUE)
                .add(mZoomBackButton)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(mMaxDepthPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );
        mControlUILayout.setVerticalGroup(
            mControlUILayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(mControlUILayout.createSequentialGroup()
                .add(mControlUILayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(mChunksPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                    .add(mZoomBackButton)
                    .add(mMaxDepthPanel, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
                .addContainerGap(org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
        );

        mSnapshotsScrollPane.setHorizontalScrollBarPolicy(javax.swing.ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        mSnapshotsScrollPane.setVerticalScrollBarPolicy(javax.swing.ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS);
        mSnapshotsScrollPane.setName("mSnapshotsScrollPane"); // NOI18N

        mSnapshotsPanel.setName("mSnapshotsPanel"); // NOI18N

        org.jdesktop.layout.GroupLayout mSnapshotsPanelLayout = new org.jdesktop.layout.GroupLayout(mSnapshotsPanel);
        mSnapshotsPanel.setLayout(mSnapshotsPanelLayout);
        mSnapshotsPanelLayout.setHorizontalGroup(
            mSnapshotsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 49, Short.MAX_VALUE)
        );
        mSnapshotsPanelLayout.setVerticalGroup(
            mSnapshotsPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(0, 199, Short.MAX_VALUE)
        );

        mSnapshotsScrollPane.setViewportView(mSnapshotsPanel);

        mAutoAnimateToggleButton.setText(resourceMap.getString("mAutoAnimateToggleButton.text")); // NOI18N
        mAutoAnimateToggleButton.setName("mAutoAnimateToggleButton"); // NOI18N
        mAutoAnimateToggleButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                mAutoAnimateToggleButtonActionPerformed(evt);
            }
        });

        org.jdesktop.layout.GroupLayout mainPanelLayout = new org.jdesktop.layout.GroupLayout(mainPanel);
        mainPanel.setLayout(mainPanelLayout);
        mainPanelLayout.setHorizontalGroup(
            mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(mControlUI, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                    .add(mainPanelLayout.createSequentialGroup()
                        .add(mBufferImagePanelContainer, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.UNRELATED)
                        .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, mSnapshotsScrollPane, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 68, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(org.jdesktop.layout.GroupLayout.TRAILING, mAutoAnimateToggleButton, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 81, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))))
                .addContainerGap())
        );
        mainPanelLayout.setVerticalGroup(
            mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(org.jdesktop.layout.GroupLayout.TRAILING, mainPanelLayout.createSequentialGroup()
                .addContainerGap()
                .add(mainPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(mainPanelLayout.createSequentialGroup()
                        .add(mSnapshotsScrollPane, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 201, Short.MAX_VALUE)
                        .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                        .add(mAutoAnimateToggleButton))
                    .add(mBufferImagePanelContainer, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(mControlUI, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE))
        );

        menuBar.setName("menuBar"); // NOI18N

        fileMenu.setText(resourceMap.getString("fileMenu.text")); // NOI18N
        fileMenu.setName("fileMenu"); // NOI18N

        javax.swing.ActionMap actionMap = org.jdesktop.application.Application.getInstance(org.bundlebee.examples.fractal.FractalApp.class).getContext().getActionMap(FractalView.class, this);
        exitMenuItem.setAction(actionMap.get("quit")); // NOI18N
        exitMenuItem.setName("exitMenuItem"); // NOI18N
        fileMenu.add(exitMenuItem);

        menuBar.add(fileMenu);

        helpMenu.setText(resourceMap.getString("helpMenu.text")); // NOI18N
        helpMenu.setName("helpMenu"); // NOI18N

        aboutMenuItem.setAction(actionMap.get("showAboutBox")); // NOI18N
        aboutMenuItem.setName("aboutMenuItem"); // NOI18N
        helpMenu.add(aboutMenuItem);

        menuBar.add(helpMenu);

        statusPanel.setName("statusPanel"); // NOI18N

        statusPanelSeparator.setName("statusPanelSeparator"); // NOI18N

        statusMessageLabel.setText(resourceMap.getString("statusMessageLabel.text")); // NOI18N
        statusMessageLabel.setName("statusMessageLabel"); // NOI18N

        statusAnimationLabel.setHorizontalAlignment(javax.swing.SwingConstants.LEFT);
        statusAnimationLabel.setText(resourceMap.getString("statusAnimationLabel.text")); // NOI18N
        statusAnimationLabel.setName("statusAnimationLabel"); // NOI18N

        progressBar.setEnabled(false);
        progressBar.setName("progressBar"); // NOI18N
        progressBar.setStringPainted(true);

        minnoQLabel.setIcon(resourceMap.getIcon("minnoQLabel.icon")); // NOI18N
        minnoQLabel.setText(resourceMap.getString("minnoQLabel.text")); // NOI18N
        minnoQLabel.setName("minnoQLabel"); // NOI18N

        org.jdesktop.layout.GroupLayout statusPanelLayout = new org.jdesktop.layout.GroupLayout(statusPanel);
        statusPanel.setLayout(statusPanelLayout);
        statusPanelLayout.setHorizontalGroup(
            statusPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(statusPanelSeparator, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 707, Short.MAX_VALUE)
            .add(statusPanelLayout.createSequentialGroup()
                .add(statusPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(statusPanelLayout.createSequentialGroup()
                        .add(62, 62, 62)
                        .add(statusMessageLabel))
                    .add(minnoQLabel))
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, 447, Short.MAX_VALUE)
                .add(progressBar, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(statusAnimationLabel)
                .addContainerGap())
        );
        statusPanelLayout.setVerticalGroup(
            statusPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(statusPanelLayout.createSequentialGroup()
                .add(statusPanelSeparator, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, 2, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                .add(statusPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.TRAILING)
                    .add(statusPanelLayout.createSequentialGroup()
                        .add(statusPanelLayout.createParallelGroup(org.jdesktop.layout.GroupLayout.BASELINE)
                            .add(progressBar, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                            .add(statusAnimationLabel)
                            .add(statusMessageLabel))
                        .add(3, 3, 3))
                    .add(minnoQLabel)))
        );

        setComponent(mainPanel);
        setMenuBar(menuBar);
        setStatusBar(statusPanel);
    }// </editor-fold>//GEN-END:initComponents

	private void mMaxDepthSpinnerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_mMaxDepthSpinnerStateChanged

		int spin = ((Integer)mMaxDepthSpinner.getValue()).intValue();
		mMandel.setMaxDepth(spin);
		mFractalContentPanel.updateContent();

}//GEN-LAST:event_mMaxDepthSpinnerStateChanged

	private void mChunksSpinnerStateChanged(javax.swing.event.ChangeEvent evt) {//GEN-FIRST:event_mChunksSpinnerStateChanged
		mMandel.setChunks( ((Integer)mChunksSpinner.getValue()).intValue() );
		mFractalContentPanel.updateContent();
	}//GEN-LAST:event_mChunksSpinnerStateChanged

	private void mZoomBackButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_mZoomBackButtonActionPerformed

		//
		// allow zooming only if animation is not running
		//
		if( mAutoAnimateHistory == -1 && mZoomHistory.size() > 0 ) {
			ComplexArea last = mZoomHistory.get(mZoomHistory.size()-1);
			mZoomHistory.remove(mZoomHistory.size()-1);
			mMandel.setArea(last);
			mFractalContentPanel.updateContent();
		}

	}//GEN-LAST:event_mZoomBackButtonActionPerformed

	private void mAutoAnimateToggleButtonActionPerformed(java.awt.event.ActionEvent evt)//GEN-FIRST:event_mAutoAnimateToggleButtonActionPerformed
	{//GEN-HEADEREND:event_mAutoAnimateToggleButtonActionPerformed

		if( mAutoAnimateToggleButton.isSelected()) {
			mAutoAnimateHistory = 0;
			mRequestObserver.finished();
		} else {
			mAutoAnimateHistory = -1;
		}

	}//GEN-LAST:event_mAutoAnimateToggleButtonActionPerformed

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JToggleButton mAutoAnimateToggleButton;
    private javax.swing.JPanel mBufferImagePanelContainer;
    private javax.swing.JPanel mChunksPanel;
    private javax.swing.JSpinner mChunksSpinner;
    private javax.swing.JPanel mControlUI;
    private javax.swing.JPanel mMaxDepthPanel;
    private javax.swing.JSpinner mMaxDepthSpinner;
    private org.bundlebee.examples.fractal.SnapshotsPanel mSnapshotsPanel;
    private javax.swing.JScrollPane mSnapshotsScrollPane;
    private javax.swing.JButton mZoomBackButton;
    private javax.swing.JPanel mainPanel;
    private javax.swing.JMenuBar menuBar;
    private javax.swing.JLabel minnoQLabel;
    private javax.swing.JProgressBar progressBar;
    private javax.swing.JLabel statusAnimationLabel;
    private javax.swing.JLabel statusMessageLabel;
    private javax.swing.JPanel statusPanel;
    // End of variables declaration//GEN-END:variables

    private final Timer messageTimer;
    private final Timer busyIconTimer;
    private final Icon idleIcon;
    private final Icon[] busyIcons = new Icon[15];
    private int busyIconIndex = 0;

    private JDialog aboutBox;

	MandelbrotContentProvider mMandel = new MandelbrotContentProvider();
	BufferedImagePanel mFractalContentPanel;
	List<ComplexArea> mZoomHistory = new ArrayList<ComplexArea>();


	private final AsynchronousContentRequest.Observer mRequestObserver = new AsynchronousContentRequest.Observer() {

		public void started()
		{
			progressBar.setEnabled(true);
		}

		public void progressed(float p)
		{
			progressBar.setMaximum(100);
			progressBar.setMinimum(0);
			progressBar.setValue((int)(p*100f));
		}

		public void finished()
		{
			progressBar.setEnabled(false);
			if( -1 != mAutoAnimateHistory && mZoomHistory.size() > 0 ) {
				
				if( mAutoAnimateHistory > mZoomHistory.size()-1 )
					mAutoAnimateHistory = 0;
				
				ComplexArea next = mZoomHistory.get(mAutoAnimateHistory);
				mAutoAnimateHistory++;
				mMandel.setArea(next);
				mFractalContentPanel.updateContent();
			}
		}
	};


	private void setupFractal() {
		mFractalContentPanel = new BufferedImagePanel( new BufferedImageProvider() {
			public BufferedImage get(JComponent j, BufferedImage old ) {
//				if( null != old ) return old;
				
				BufferedImage image = new BufferedImage( j.getWidth(), j.getHeight(), BufferedImage.TYPE_INT_ARGB );
				return image;
			}
		}, mMandel );
		mFractalContentPanel.setRequestObserver(mRequestObserver);

		// make the progressbar visible by default and never switch it of
		// switching visibility causes a relayout and thus a resizing -> updateContent
		progressBar.setVisible(true);

		mBufferImagePanelContainer.setLayout(new GridLayout());
		mBufferImagePanelContainer.add(mFractalContentPanel);

		mMaxDepthSpinner.setValue(MandelbrotContentProvider.DEFAULT_MAXDEPTH);
		mChunksSpinner.setValue(MandelbrotContentProvider.DEFAULT_CHUNKS);

		mFractalContentPanel.addZoomListener(new BufferedImagePanel.ZoomListener() {
			public void zoomTo(Rectangle r) {
				
				//
				// allow zooming only if animation is not running
				//
				if( mAutoAnimateHistory == -1 ) {
					ComplexArea displayedarea = mMandel.getDisplayedArea(mFractalContentPanel.getSize());

					SnapshotPanel snp = new SnapshotPanel(mFractalContentPanel,mMandel,displayedarea);
					mSnapshotsPanel.addSnapshot(snp);

					mZoomHistory.add( mMandel.getDisplayedArea(mFractalContentPanel.getSize()) );
					mMandel.zoomTo(mFractalContentPanel.getSize(), r);
					mFractalContentPanel.updateContent();
				}
			}
		});

//		ContentProvider foo = new ContentProvider() {
//
//			public void request( final AsynchronousContentRequest r) {
//				Thread t = new Thread( new Runnable() {
//
//					public void run() {
//						try {
//							Thread.currentThread().sleep(100L);
//						} catch (InterruptedException ex) {}
//						Graphics2D g = r.getBufferedImage().createGraphics();
//						g.setColor( Color.RED );
//						g.setStroke( new BasicStroke(2) );
//						for( Rectangle rect : r.getRectangles() ) {
//							g.drawLine( 0, 0, rect.width, rect.height );
//							r.updated(rect);
//						}
//						g.dispose();
//					}
//				});
//				t.start();
//			}
//		};

	}
}
