/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.examples.fractal;

import java.awt.AlphaComposite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.bundlebee.examples.fractal.BufferedImagePanel;
import org.bundlebee.examples.fractal.mandelbrot.ComplexArea;
import org.bundlebee.examples.fractal.mandelbrot.MandelbrotContentProvider;

public class SnapshotPanel
extends JPanel {
    public static final int SIZE = 48;
    BufferedImage mImage = new BufferedImage(48, 48, 2);
    private final MandelbrotContentProvider mMandel;
    private final ComplexArea mArea;

    public SnapshotPanel(final BufferedImagePanel srcpanel, MandelbrotContentProvider mandel, ComplexArea area) {
        this.mMandel = mandel;
        this.mArea = area;
        this.setSize(48, 48);
        this.setPreferredSize(new Dimension(48, 48));
        BufferedImage srcimage = srcpanel.getImage();
        BufferedImage tmpimage = new BufferedImage(48, 48, 2);
        Graphics2D g = tmpimage.createGraphics();
        g.drawImage(srcimage, 0, 0, 48, 48, null);
        g.dispose();
        g = this.mImage.createGraphics();
        int x = 0;
        int y = 0;
        int w = this.getWidth();
        int h = this.getHeight();
        int b = 1;
        Polygon p = new Polygon(new int[]{x, x + w, x + w, x, x, x + b, x + b, x + w - b, x + w - b, x}, new int[]{y, y, y + h, y + h, y + b, y + b, y + h - b, y + h - b, y + b, y + b}, 10);
        g.setClip(p);
        g.setComposite(AlphaComposite.getInstance(2, 0.2f));
        g.drawImage((Image)tmpimage, 0, 0, null);
        p = new Polygon(new int[]{x += b, x + (w -= 2 * b), x + w, x, x, x + b, x + b, x + w - b, x + w - b, x}, new int[]{y += b, y, y + (h -= 2 * b), y + h, y + b, y + b, y + h - b, y + h - b, y + b, y + b}, 10);
        g.setClip(p);
        g.setComposite(AlphaComposite.getInstance(2, 0.4f));
        g.drawImage((Image)tmpimage, 0, 0, null);
        p = new Polygon(new int[]{x += b, x + (w -= 2 * b), x + w, x, x, x + b, x + b, x + w - b, x + w - b, x}, new int[]{y += b, y, y + (h -= 2 * b), y + h, y + b, y + b, y + h - b, y + h - b, y + b, y + b}, 10);
        g.setClip(p);
        g.setComposite(AlphaComposite.getInstance(2, 0.7f));
        g.drawImage((Image)tmpimage, 0, 0, null);
        g.setClip(new Rectangle(x + b, x + b, w - 2 * b, h - 2 * b));
        g.setComposite(AlphaComposite.Src);
        g.drawImage((Image)tmpimage, 0, 0, null);
        g.dispose();
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent e) {
                super.mouseClicked(e);
                SnapshotPanel.this.mMandel.setArea(SnapshotPanel.this.mArea);
                srcpanel.updateContent();
            }
        });
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.drawImage((Image)this.mImage, 0, 0, null);
    }
}

