/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.classic.db;

import ch.qos.logback.classic.db.DBHelper;
import ch.qos.logback.classic.spi.CallerData;
import ch.qos.logback.classic.spi.LoggingEvent;
import ch.qos.logback.core.db.DBAppenderBase;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DBAppender
extends DBAppenderBase<LoggingEvent> {
    protected final String insertPropertiesSQL = "INSERT INTO  logging_event_property (event_id, mapped_key, mapped_value) VALUES (?, ?, ?)";
    protected final String insertExceptionSQL = "INSERT INTO  logging_event_exception (event_id, i, trace_line) VALUES (?, ?, ?)";
    protected static final String insertSQL;
    protected static final Method GET_GENERATED_KEYS_METHOD;

    @Override
    protected void subAppend(Object eventObject, Connection connection, PreparedStatement insertStatement) throws Throwable {
        LoggingEvent event = (LoggingEvent)eventObject;
        this.addLoggingEvent(insertStatement, event);
        this.addCallerData(insertStatement, event.getCallerData());
        int updateCount = insertStatement.executeUpdate();
        if (updateCount != 1) {
            this.addWarn("Failed to insert loggingEvent");
        }
        int eventId = this.getEventId(insertStatement, connection);
        Map<String, String> mergedMap = this.mergePropertyMaps(event);
        this.insertProperties(mergedMap, connection, eventId);
        if (event.getThrowableInformation() != null) {
            this.insertThrowable(event.getThrowableInformation().getThrowableStrRep(), connection, eventId);
        }
    }

    void addLoggingEvent(PreparedStatement stmt, LoggingEvent event) throws SQLException {
        stmt.setLong(1, event.getTimeStamp());
        stmt.setString(2, event.getFormattedMessage());
        stmt.setString(3, event.getLoggerRemoteView().getName());
        stmt.setString(4, event.getLevel().toString());
        stmt.setString(5, event.getThreadName());
        stmt.setShort(6, DBHelper.computeReferenceMask(event));
    }

    void addCallerData(PreparedStatement stmt, CallerData[] callerDataArray) throws SQLException {
        CallerData callerData = callerDataArray[0];
        if (callerData != null) {
            stmt.setString(7, callerData.getFileName());
            stmt.setString(8, callerData.getClassName());
            stmt.setString(9, callerData.getMethodName());
            stmt.setString(10, Integer.toString(callerData.getLineNumber()));
        }
    }

    Map<String, String> mergePropertyMaps(LoggingEvent event) {
        HashMap<String, String> mergedMap = new HashMap<String, String>();
        Map<String, String> loggerContextMap = event.getLoggerRemoteView().getLoggerContextView().getPropertyMap();
        Map<String, String> mdcMap = event.getMDCPropertyMap();
        if (loggerContextMap != null) {
            mergedMap.putAll(loggerContextMap);
        }
        if (mdcMap != null) {
            mergedMap.putAll(mdcMap);
        }
        return mergedMap;
    }

    @Override
    protected Method getGeneratedKeysMethod() {
        return GET_GENERATED_KEYS_METHOD;
    }

    @Override
    protected String getInsertSQL() {
        return insertSQL;
    }

    protected void insertProperties(Map<String, String> mergedMap, Connection connection, int eventId) throws SQLException {
        Set<String> propertiesKeys = mergedMap.keySet();
        if (propertiesKeys.size() > 0) {
            PreparedStatement insertPropertiesStatement = connection.prepareStatement("INSERT INTO  logging_event_property (event_id, mapped_key, mapped_value) VALUES (?, ?, ?)");
            for (String key : propertiesKeys) {
                String value = mergedMap.get(key);
                insertPropertiesStatement.setInt(1, eventId);
                insertPropertiesStatement.setString(2, key);
                insertPropertiesStatement.setString(3, value);
                if (this.cnxSupportsBatchUpdates) {
                    insertPropertiesStatement.addBatch();
                    continue;
                }
                insertPropertiesStatement.execute();
            }
            if (this.cnxSupportsBatchUpdates) {
                insertPropertiesStatement.executeBatch();
            }
            insertPropertiesStatement.close();
            insertPropertiesStatement = null;
        }
    }

    protected void insertThrowable(String[] strRep, Connection connection, int eventId) throws SQLException {
        PreparedStatement insertExceptionStatement = connection.prepareStatement("INSERT INTO  logging_event_exception (event_id, i, trace_line) VALUES (?, ?, ?)");
        for (short i = 0; i < strRep.length; i = (short)(i + 1)) {
            insertExceptionStatement.setInt(1, eventId);
            insertExceptionStatement.setShort(2, i);
            insertExceptionStatement.setString(3, strRep[i]);
            if (this.cnxSupportsBatchUpdates) {
                insertExceptionStatement.addBatch();
                continue;
            }
            insertExceptionStatement.execute();
        }
        if (this.cnxSupportsBatchUpdates) {
            insertExceptionStatement.executeBatch();
        }
        insertExceptionStatement.close();
        insertExceptionStatement = null;
    }

    static {
        Method getGeneratedKeysMethod;
        StringBuffer sql = new StringBuffer();
        sql.append("INSERT INTO logging_event (");
        sql.append("timestmp, ");
        sql.append("formatted_message, ");
        sql.append("logger_name, ");
        sql.append("level_string, ");
        sql.append("thread_name, ");
        sql.append("reference_flag, ");
        sql.append("caller_filename, ");
        sql.append("caller_class, ");
        sql.append("caller_method, ");
        sql.append("caller_line) ");
        sql.append(" VALUES (?, ?, ? ,?, ?, ?, ?, ?, ?,?)");
        insertSQL = sql.toString();
        try {
            getGeneratedKeysMethod = PreparedStatement.class.getMethod("getGeneratedKeys", null);
        }
        catch (Exception ex) {
            getGeneratedKeysMethod = null;
        }
        GET_GENERATED_KEYS_METHOD = getGeneratedKeysMethod;
    }
}

