/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.weaver;

import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.bundlebee.registry.Registry;
import org.bundlebee.remoteservicecall.BundleLifecycleClient;
import org.bundlebee.weaver.ServiceCallDispatchStrategy;
import org.bundlebee.weaver.ServiceCallStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RoundRobinDispatchStrategy
implements ServiceCallDispatchStrategy {
    private static Logger LOG = LoggerFactory.getLogger(RoundRobinDispatchStrategy.class);
    private Registry registry;
    private List<URL> managerList = new ArrayList<URL>();
    private int index;
    private final BundleLifecycleClient bundleLifecycleClient = new BundleLifecycleClient();

    public RoundRobinDispatchStrategy() {
        LOG.info("Initializing RoundRobinDispatchStrategy");
    }

    public void setRegistry(Registry registry) {
        this.registry = registry;
    }

    public void setServiceCallStats(ServiceCallStats serviceCallStats) {
    }

    public synchronized URI getManagerURI(String bundleSymbolicNameVersion, Object service, String methodname, Class[] parameterTypes) {
        try {
            this.updateManagerList();
            if (this.managerList.isEmpty()) {
                return null;
            }
            this.index %= this.managerList.size();
            URL url = this.managerList.get(this.index);
            ++this.index;
            URL url2 = this.installAndStartBundle(bundleSymbolicNameVersion, url);
            if (url2 == null) {
                return null;
            }
            return url2.toURI();
        }
        catch (URISyntaxException e) {
            LOG.error(e.toString(), e);
            return null;
        }
    }

    private URL installAndStartBundle(String bundleSymbolicNameVersion, URL url) {
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(url);
        if (this.registry.getGrid().getManagers(bundleSymbolicNameVersion, 2).contains(url) || this.registry.getGrid().getManagers(bundleSymbolicNameVersion, 4).contains(url)) {
            urls.retainAll(this.bundleLifecycleClient.startBundle(urls, bundleSymbolicNameVersion));
        } else if (this.registry.getGrid().getManagers(bundleSymbolicNameVersion, 1).contains(url)) {
            urls.retainAll(this.bundleLifecycleClient.installAndStartBundle(urls, bundleSymbolicNameVersion));
        } else {
            urls.retainAll(this.bundleLifecycleClient.installAndStartBundle(urls, bundleSymbolicNameVersion));
        }
        if (urls.isEmpty()) {
            return null;
        }
        return (URL)urls.iterator().next();
    }

    private void updateManagerList() {
        Set<URL> currentManagerURLs = this.registry.getGrid().getManagers();
        this.managerList.retainAll(currentManagerURLs);
        for (URL url : currentManagerURLs) {
            if (this.managerList.contains(url)) continue;
            this.managerList.add(url);
        }
    }
}

