/*
 * Decompiled with CFR 0.152.
 */
package org.bundlebee.remoteservicecall;

import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import org.bundlebee.remoteservicecall.Call;
import org.bundlebee.remoteservicecall.CallRuntimeException;
import org.bundlebee.remoteservicecall.ObjectInputStreamWithServiceClassLoader;
import org.bundlebee.remoteservicecall.Result;
import org.bundlebee.remoteservicecall.ServiceNotAvailableException;
import org.bundlebee.remoteservicecall.StaticCallContext;
import org.osgi.framework.BundleContext;

public class Callee {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Result executeCall(InputStream is, OutputStream os, BundleContext ctx) throws IOException {
        Result r;
        StaticCallContext.forceLocal();
        try {
            ObjectInputStreamWithServiceClassLoader ois = new ObjectInputStreamWithServiceClassLoader(is, ctx);
            r = Callee.execute(ois);
            new ObjectOutputStream(os).writeObject(r);
        }
        finally {
            StaticCallContext.clearForceLocal();
        }
        return r;
    }

    private static Result execute(ObjectInputStreamWithServiceClassLoader ois) throws IOException {
        try {
            Call cremote = (Call)ois.readObject();
            Object r = cremote.execute();
            return new Result(r, Result.ValueType.REGULAR);
        }
        catch (InvocationTargetException ex) {
            return new Result(ex.getCause(), Result.ValueType.TARGETEXCEPTION);
        }
        catch (ServiceNotAvailableException ex) {
            return new Result(ex, Result.ValueType.SERVICEEXCEPTION);
        }
        catch (CallRuntimeException ex) {
            return new Result(ex, Result.ValueType.CALLRUNTIMEXCEPTION);
        }
        catch (ClassNotFoundException ex) {
            return new Result(ex, Result.ValueType.CALLRUNTIMEXCEPTION);
        }
    }
}

