/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.client;



import java.util.Collection;
import org.opends.server.admin.client.AuthorizationException;
import org.opends.server.admin.client.CommunicationException;
import org.opends.server.admin.client.ConcurrentModificationException;
import org.opends.server.admin.client.IllegalManagedObjectNameException;
import org.opends.server.admin.client.ManagedObjectDecodingException;
import org.opends.server.admin.client.OperationRejectedException;
import org.opends.server.admin.DefinitionDecodingException;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.ManagedObjectNotFoundException;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.std.meta.AccessLogPublisherCfgDefn.FilteringPolicy;
import org.opends.server.admin.std.server.AccessLogFilteringCriteriaCfg;
import org.opends.server.admin.std.server.AccessLogPublisherCfg;



/**
 * A client-side interface for reading and modifying Access Log
 * Publisher settings.
 * <p>
 * Access Log Publishers are responsible for distributing access log
 * messages from the access logger to a destination.
 */
public interface AccessLogPublisherCfgClient extends LogPublisherCfgClient {

  /**
   * Get the configuration definition associated with this Access Log Publisher.
   *
   * @return Returns the configuration definition associated with this Access Log Publisher.
   */
  ManagedObjectDefinition<? extends AccessLogPublisherCfgClient, ? extends AccessLogPublisherCfg> definition();



  /**
   * Gets the "filtering-policy" property.
   * <p>
   * Specifies how filtering criteria should be applied to log
   * records.
   *
   * @return Returns the value of the "filtering-policy" property.
   */
  FilteringPolicy getFilteringPolicy();



  /**
   * Sets the "filtering-policy" property.
   * <p>
   * Specifies how filtering criteria should be applied to log
   * records.
   *
   * @param value The value of the "filtering-policy" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setFilteringPolicy(FilteringPolicy value) throws PropertyException;



  /**
   * Gets the "java-class" property.
   * <p>
   * The fully-qualified name of the Java class that provides the
   * Access Log Publisher implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();



  /**
   * Sets the "java-class" property.
   * <p>
   * The fully-qualified name of the Java class that provides the
   * Access Log Publisher implementation.
   *
   * @param value The value of the "java-class" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setJavaClass(String value) throws PropertyException;



  /**
   * Gets the "suppress-internal-operations" property.
   * <p>
   * Indicates whether internal operations (for example, operations
   * that are initiated by plugins) should be logged along with the
   * operations that are requested by users.
   *
   * @return Returns the value of the "suppress-internal-operations" property.
   */
  boolean isSuppressInternalOperations();



  /**
   * Sets the "suppress-internal-operations" property.
   * <p>
   * Indicates whether internal operations (for example, operations
   * that are initiated by plugins) should be logged along with the
   * operations that are requested by users.
   *
   * @param value The value of the "suppress-internal-operations" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setSuppressInternalOperations(Boolean value) throws PropertyException;



  /**
   * Gets the "suppress-synchronization-operations" property.
   * <p>
   * Indicates whether access messages that are generated by
   * synchronization operations should be suppressed.
   *
   * @return Returns the value of the "suppress-synchronization-operations" property.
   */
  boolean isSuppressSynchronizationOperations();



  /**
   * Sets the "suppress-synchronization-operations" property.
   * <p>
   * Indicates whether access messages that are generated by
   * synchronization operations should be suppressed.
   *
   * @param value The value of the "suppress-synchronization-operations" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setSuppressSynchronizationOperations(Boolean value) throws PropertyException;



  /**
   * Lists the Access Log Filtering Criteria.
   *
   * @return Returns an array containing the names of the Access Log
   *         Filtering Criteria.
   * @throws ConcurrentModificationException
   *           If this Access Log Publisher has been removed from the
   *           server by another client.
   * @throws AuthorizationException
   *           If the server refuses to list the Access Log Filtering
   *           Criteria because the client does not have the correct
   *           privileges.
   * @throws CommunicationException
   *           If the client cannot contact the server due to an
   *           underlying communication problem.
   */
  String[] listAccessLogFilteringCriteria() throws ConcurrentModificationException,
      AuthorizationException, CommunicationException;



  /**
   * Gets the named Access Log Filtering Criteria.
   *
   * @param name
   *           The name of the Access Log Filtering Criteria to
   *           retrieve.
   * @return Returns the named Access Log Filtering Criteria.
   * @throws DefinitionDecodingException
   *           If the named Access Log Filtering Criteria was found
   *           but its type could not be determined.
   * @throws ManagedObjectDecodingException
   *           If the named Access Log Filtering Criteria was found
   *           but one or more of its properties could not be decoded.
   * @throws ManagedObjectNotFoundException
   *           If the named Access Log Filtering Criteria was not
   *           found on the server.
   * @throws ConcurrentModificationException
   *           If this Access Log Publisher has been removed from the
   *           server by another client.
   * @throws AuthorizationException
   *           If the server refuses to retrieve the named Access Log
   *           Filtering Criteria because the client does not have the
   *           correct privileges.
   * @throws CommunicationException
   *           If the client cannot contact the server due to an
   *           underlying communication problem.
   */
  AccessLogFilteringCriteriaCfgClient getAccessLogFilteringCriteria(String name)
      throws DefinitionDecodingException, ManagedObjectDecodingException,
      ManagedObjectNotFoundException, ConcurrentModificationException,
      AuthorizationException, CommunicationException;



  /**
   * Creates a new Access Log Filtering Criteria. The new Access Log
   * Filtering Criteria will initially not contain any property values
   * (including mandatory properties). Once the Access Log Filtering
   * Criteria has been configured it can be added to the server using
   * the {@link #commit()} method.
   *
   * @param <C>
   *          The type of the Access Log Filtering Criteria being
   *          created.
   * @param d
   *          The definition of the Access Log Filtering Criteria to
   *          be created.
   * @param name
   *          The name of the new Access Log Filtering Criteria.
   * @param exceptions
   *          An optional collection in which to place any {@link
   *          PropertyException}s that occurred whilst attempting to
   *          determine the default values of the Access Log Filtering
   *          Criteria. This argument can be <code>null<code>.
   * @return Returns a new Access Log Filtering Criteria configuration
   *         instance.
   * @throws IllegalManagedObjectNameException
   *          If the name of the new Access Log Filtering Criteria is
   *          invalid.
   */
  <C extends AccessLogFilteringCriteriaCfgClient> C createAccessLogFilteringCriteria(
      ManagedObjectDefinition<C, ? extends AccessLogFilteringCriteriaCfg> d, String name, Collection<PropertyException> exceptions) throws IllegalManagedObjectNameException;



  /**
   * Removes the named Access Log Filtering Criteria.
   *
   * @param name
   *          The name of the Access Log Filtering Criteria to remove.
   * @throws ManagedObjectNotFoundException
   *           If the Access Log Filtering Criteria does not exist.
   * @throws OperationRejectedException
   *           If the server refuses to remove the Access Log
   *           Filtering Criteria due to some server-side constraint
   *           which cannot be satisfied (for example, if it is
   *           referenced by another managed object).
   * @throws ConcurrentModificationException
   *           If this Access Log Publisher has been removed from the
   *           server by another client.
   * @throws AuthorizationException
   *           If the server refuses to remove the Access Log
   *           Filtering Criteria because the client does not have the
   *           correct privileges.
   * @throws CommunicationException
   *           If the client cannot contact the server due to an
   *           underlying communication problem.
   */
  void removeAccessLogFilteringCriteria(String name)
      throws ManagedObjectNotFoundException, OperationRejectedException,
      ConcurrentModificationException, AuthorizationException,
      CommunicationException;

}
