/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.client;



import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.std.server.CountryStringAttributeSyntaxCfg;



/**
 * A client-side interface for reading and modifying Country String
 * Attribute Syntax settings.
 * <p>
 * Country String Attribute Syntaxes define an attribute syntax for
 * storing country codes.
 */
public interface CountryStringAttributeSyntaxCfgClient extends AttributeSyntaxCfgClient {

  /**
   * Get the configuration definition associated with this Country String Attribute Syntax.
   *
   * @return Returns the configuration definition associated with this Country String Attribute Syntax.
   */
  ManagedObjectDefinition<? extends CountryStringAttributeSyntaxCfgClient, ? extends CountryStringAttributeSyntaxCfg> definition();



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Country String Attribute Syntax implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();



  /**
   * Sets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Country String Attribute Syntax implementation.
   * <p>
   * This property is read-only and can only be modified during
   * creation of a Country String Attribute Syntax.
   *
   * @param value The value of the "java-class" property.
   * @throws PropertyException
   *           If the new value is invalid.
   * @throws PropertyException
   *           If this Country String Attribute Syntax is not being initialized.
   */
  void setJavaClass(String value) throws PropertyException, PropertyException;



  /**
   * Gets the "strict-format" property.
   * <p>
   * Indicates whether or not country code values are required to
   * strictly comply with the standard definition for this syntax.
   * <p>
   * When set to false, country codes will not be validated and, as a
   * result any string containing 2 characters will be acceptable.
   *
   * @return Returns the value of the "strict-format" property.
   */
  boolean isStrictFormat();



  /**
   * Sets the "strict-format" property.
   * <p>
   * Indicates whether or not country code values are required to
   * strictly comply with the standard definition for this syntax.
   * <p>
   * When set to false, country codes will not be validated and, as a
   * result any string containing 2 characters will be acceptable.
   *
   * @param value The value of the "strict-format" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setStrictFormat(Boolean value) throws PropertyException;

}
