/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.client;



import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.std.server.FileCountLogRetentionPolicyCfg;



/**
 * A client-side interface for reading and modifying File Count Log
 * Retention Policy settings.
 * <p>
 * Retention policy based on the number of rotated log files on disk.
 */
public interface FileCountLogRetentionPolicyCfgClient extends LogRetentionPolicyCfgClient {

  /**
   * Get the configuration definition associated with this File Count Log Retention Policy.
   *
   * @return Returns the configuration definition associated with this File Count Log Retention Policy.
   */
  ManagedObjectDefinition<? extends FileCountLogRetentionPolicyCfgClient, ? extends FileCountLogRetentionPolicyCfg> definition();



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the File Count Log Retention Policy implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();



  /**
   * Sets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the File Count Log Retention Policy implementation.
   *
   * @param value The value of the "java-class" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setJavaClass(String value) throws PropertyException;



  /**
   * Gets the "number-of-files" property.
   * <p>
   * Specifies the number of archived log files to retain before the
   * oldest ones are cleaned.
   *
   * @return Returns the value of the "number-of-files" property.
   */
  Integer getNumberOfFiles();



  /**
   * Sets the "number-of-files" property.
   * <p>
   * Specifies the number of archived log files to retain before the
   * oldest ones are cleaned.
   *
   * @param value The value of the "number-of-files" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setNumberOfFiles(int value) throws PropertyException;

}
