/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.client;



import java.net.InetAddress;
import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.std.server.JMXConnectionHandlerCfg;



/**
 * A client-side interface for reading and modifying JMX Connection
 * Handler settings.
 * <p>
 * The JMX Connection Handler is used to interact with clients using
 * the Java Management Extensions (JMX) protocol.
 */
public interface JMXConnectionHandlerCfgClient extends ConnectionHandlerCfgClient {

  /**
   * Get the configuration definition associated with this JMX Connection Handler.
   *
   * @return Returns the configuration definition associated with this JMX Connection Handler.
   */
  ManagedObjectDefinition<? extends JMXConnectionHandlerCfgClient, ? extends JMXConnectionHandlerCfg> definition();



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the JMX Connection Handler implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();



  /**
   * Sets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the JMX Connection Handler implementation.
   *
   * @param value The value of the "java-class" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setJavaClass(String value) throws PropertyException;



  /**
   * Gets the "key-manager-provider" property.
   * <p>
   * Specifies the name of the key manager that should be used with
   * this JMX Connection Handler .
   *
   * @return Returns the value of the "key-manager-provider" property.
   */
  String getKeyManagerProvider();



  /**
   * Sets the "key-manager-provider" property.
   * <p>
   * Specifies the name of the key manager that should be used with
   * this JMX Connection Handler .
   *
   * @param value The value of the "key-manager-provider" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setKeyManagerProvider(String value) throws PropertyException;



  /**
   * Gets the "listen-address" property.
   * <p>
   * Specifies the address on which this JMX Connection Handler should
   * listen for connections from JMX clients.
   * <p>
   * If no value is provided, then the JMX Connection Handler listens
   * on all interfaces.
   *
   * @return Returns the value of the "listen-address" property.
   */
  InetAddress getListenAddress();



  /**
   * Sets the "listen-address" property.
   * <p>
   * Specifies the address on which this JMX Connection Handler should
   * listen for connections from JMX clients.
   * <p>
   * If no value is provided, then the JMX Connection Handler listens
   * on all interfaces.
   *
   * @param value The value of the "listen-address" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setListenAddress(InetAddress value) throws PropertyException;



  /**
   * Gets the "listen-port" property.
   * <p>
   * Specifies the port number on which the JMX Connection Handler
   * will listen for connections from clients.
   * <p>
   * Only a single port number may be provided.
   *
   * @return Returns the value of the "listen-port" property.
   */
  Integer getListenPort();



  /**
   * Sets the "listen-port" property.
   * <p>
   * Specifies the port number on which the JMX Connection Handler
   * will listen for connections from clients.
   * <p>
   * Only a single port number may be provided.
   *
   * @param value The value of the "listen-port" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setListenPort(int value) throws PropertyException;



  /**
   * Gets the "rmi-port" property.
   * <p>
   * Specifies the port number on which the JMX RMI service will
   * listen for connections from clients. A value of 0 indicates the
   * service to choose a port of its own.
   * <p>
   * If the value provided is different than 0, the value will be used
   * as the RMI port. Otherwise, the RMI service will choose a port of
   * its own.
   *
   * @return Returns the value of the "rmi-port" property.
   */
  int getRmiPort();



  /**
   * Sets the "rmi-port" property.
   * <p>
   * Specifies the port number on which the JMX RMI service will
   * listen for connections from clients. A value of 0 indicates the
   * service to choose a port of its own.
   * <p>
   * If the value provided is different than 0, the value will be used
   * as the RMI port. Otherwise, the RMI service will choose a port of
   * its own.
   *
   * @param value The value of the "rmi-port" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setRmiPort(Integer value) throws PropertyException;



  /**
   * Gets the "ssl-cert-nickname" property.
   * <p>
   * Specifies the nickname (also called the alias) of the certificate
   * that the JMX Connection Handler should use when performing SSL
   * communication.
   * <p>
   * This is only applicable when the JMX Connection Handler is
   * configured to use SSL.
   *
   * @return Returns the value of the "ssl-cert-nickname" property.
   */
  String getSSLCertNickname();



  /**
   * Sets the "ssl-cert-nickname" property.
   * <p>
   * Specifies the nickname (also called the alias) of the certificate
   * that the JMX Connection Handler should use when performing SSL
   * communication.
   * <p>
   * This is only applicable when the JMX Connection Handler is
   * configured to use SSL.
   *
   * @param value The value of the "ssl-cert-nickname" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setSSLCertNickname(String value) throws PropertyException;



  /**
   * Gets the "use-ssl" property.
   * <p>
   * Indicates whether the JMX Connection Handler should use SSL.
   * <p>
   * If enabled, the JMX Connection Handler will use SSL to encrypt
   * communication with the clients.
   *
   * @return Returns the value of the "use-ssl" property.
   */
  boolean isUseSSL();



  /**
   * Sets the "use-ssl" property.
   * <p>
   * Indicates whether the JMX Connection Handler should use SSL.
   * <p>
   * If enabled, the JMX Connection Handler will use SSL to encrypt
   * communication with the clients.
   *
   * @param value The value of the "use-ssl" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setUseSSL(Boolean value) throws PropertyException;

}
