/*
 * CDDL HEADER START
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only
 * (the "License").  You may not use this file except in compliance
 * with the License.
 *
 * You can obtain a copy of the license at legal-notices/CDDLv1_0.txt
 * or http://forgerock.org/license/CDDLv1.0.html.
 * See the License for the specific language governing permissions
 * and limitations under the License.
 *
 * When distributing Covered Code, include this CDDL HEADER in each
 * file and include the License file at legal-notices/CDDLv1_0.txt.
 * If applicable, add the following below this CDDL HEADER, with the
 * fields enclosed by brackets "[]" replaced with your own identifying
 * information:
 *      Portions Copyright [yyyy] [name of copyright owner]
 *
 * CDDL HEADER END
 *
 *
 *      Copyright 2008 Sun Microsystems, Inc.
 */
package org.opends.server.admin.std.client;



import org.opends.server.admin.ManagedObjectDefinition;
import org.opends.server.admin.PropertyException;
import org.opends.server.admin.std.server.MemoryUsageMonitorProviderCfg;



/**
 * A client-side interface for reading and modifying Memory Usage
 * Monitor Provider settings.
 * <p>
 * The Memory Usage Monitor Provider can be used to publish
 * information about memory consumption and garbage collection activity
 * in the JVM.
 */
public interface MemoryUsageMonitorProviderCfgClient extends MonitorProviderCfgClient {

  /**
   * Get the configuration definition associated with this Memory Usage Monitor Provider.
   *
   * @return Returns the configuration definition associated with this Memory Usage Monitor Provider.
   */
  ManagedObjectDefinition<? extends MemoryUsageMonitorProviderCfgClient, ? extends MemoryUsageMonitorProviderCfg> definition();



  /**
   * Gets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Memory Usage Monitor Provider implementation.
   *
   * @return Returns the value of the "java-class" property.
   */
  String getJavaClass();



  /**
   * Sets the "java-class" property.
   * <p>
   * Specifies the fully-qualified name of the Java class that
   * provides the Memory Usage Monitor Provider implementation.
   *
   * @param value The value of the "java-class" property.
   * @throws PropertyException
   *           If the new value is invalid.
   */
  void setJavaClass(String value) throws PropertyException;

}
